/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.group.dao;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.artemis.management.common.OperationContext;
import org.mydotey.artemis.management.group.Group;
import org.mydotey.artemis.management.group.GroupWeight;
import org.mydotey.artemis.management.group.RouteRuleInfo;
import org.mydotey.artemis.management.group.ServiceRouteRule;
import org.mydotey.artemis.management.group.dao.GroupDao;
import org.mydotey.artemis.management.group.dao.GroupInstanceDao;
import org.mydotey.artemis.management.group.dao.GroupInstanceLogDao;
import org.mydotey.artemis.management.group.dao.GroupLogDao;
import org.mydotey.artemis.management.group.dao.GroupOperationDao;
import org.mydotey.artemis.management.group.dao.GroupOperationLogDao;
import org.mydotey.artemis.management.group.dao.RouteRuleDao;
import org.mydotey.artemis.management.group.dao.RouteRuleGroupDao;
import org.mydotey.artemis.management.group.dao.RouteRuleGroupLogDao;
import org.mydotey.artemis.management.group.dao.RouteRuleLogDao;
import org.mydotey.artemis.management.group.dao.ServiceInstanceDao;
import org.mydotey.artemis.management.group.dao.ServiceInstanceLogDao;
import org.mydotey.artemis.management.group.model.GroupInstanceModel;
import org.mydotey.artemis.management.group.model.GroupModel;
import org.mydotey.artemis.management.group.model.GroupOperationModel;
import org.mydotey.artemis.management.group.model.RouteRuleGroupModel;
import org.mydotey.artemis.management.group.model.RouteRuleModel;
import org.mydotey.artemis.management.group.model.ServiceInstanceModel;
import org.mydotey.artemis.management.group.util.GroupInstances;
import org.mydotey.artemis.management.group.util.GroupOperationsUtil;
import org.mydotey.artemis.management.group.util.Groups;
import org.mydotey.artemis.management.group.util.RouteRuleGroups;
import org.mydotey.artemis.management.group.util.ServiceInstances;
import org.mydotey.artemis.management.group.util.ServiceRouteRules;
import org.mydotey.java.collection.CollectionExtension;
import org.springframework.transaction.annotation.Transactional;

public class BusinessDao {
    public static final BusinessDao INSTANCE = new BusinessDao();
    private final RouteRuleDao routeRuleDao = RouteRuleDao.INSTANCE;
    private final GroupDao groupDao = GroupDao.INSTANCE;
    private final RouteRuleGroupDao routeRuleGroupDao = RouteRuleGroupDao.INSTANCE;
    private final GroupOperationDao groupOperationDao = GroupOperationDao.INSTANCE;
    private final GroupLogDao groupLogDao = GroupLogDao.INSTANCE;
    private final GroupOperationLogDao groupOperationLogDao = GroupOperationLogDao.INSTANCE;
    private final RouteRuleLogDao routeRuleLogDao = RouteRuleLogDao.INSTANCE;
    private final RouteRuleGroupLogDao routeRuleGroupLogDao = RouteRuleGroupLogDao.INSTANCE;
    private final GroupInstanceDao groupInstanceDao = GroupInstanceDao.INSTANCE;
    private final GroupInstanceLogDao groupInstanceLogDao = GroupInstanceLogDao.INSTANCE;
    private final ServiceInstanceDao serviceInstanceDao = ServiceInstanceDao.INSTANCE;
    private final ServiceInstanceLogDao serviceInstanceLogDao = ServiceInstanceLogDao.INSTANCE;

    @Transactional
    public void createServiceRouteRules(OperationContext operationContext, String serviceId, List<RouteRuleInfo> routeRuleInfos) {
        this.checkServiceRouteRules(serviceId, routeRuleInfos);
        ArrayList routeRuleModels = Lists.newArrayList();
        HashMap groupModels = Maps.newHashMap();
        ArrayListMultimap routeRuleGroups = ArrayListMultimap.create();
        for (RouteRuleInfo info : routeRuleInfos) {
            routeRuleModels.add(ServiceRouteRules.newRouteRuleModel(info.getRouteRule()));
            for (GroupWeight group : info.getGroups()) {
                String groupKey = group.getGroupKey();
                groupModels.put(groupKey, Groups.newGroupModel(group));
                routeRuleGroups.put((Object)info.getRouteRule().getName().toLowerCase(), (Object)group);
            }
        }
        this.insertRouteRules(operationContext, routeRuleModels);
        this.insertGroups(operationContext, Lists.newArrayList(groupModels.values()));
        this.insertOrUpdateRouteRuleGroups(operationContext, this.getRouteRuleGroups(serviceId, (ListMultimap<String, GroupWeight>)routeRuleGroups));
    }

    @Transactional
    public void activateServiceRouteRules(OperationContext operationContext, String serviceId, List<RouteRuleInfo> routeRuleInfos) {
        this.checkServiceRouteRules(serviceId, routeRuleInfos);
        ArrayList routeRuleModels = Lists.newArrayList();
        HashMap groupModels = Maps.newHashMap();
        ArrayListMultimap routeRuleGroups = ArrayListMultimap.create();
        for (RouteRuleInfo routeRuleInfo : routeRuleInfos) {
            RouteRuleModel routeRuleModel = ServiceRouteRules.newRouteRuleModel(routeRuleInfo.getRouteRule());
            routeRuleModel.setStatus("active");
            routeRuleModels.add(routeRuleModel);
            for (GroupWeight group : routeRuleInfo.getGroups()) {
                String groupKey = group.getGroupKey();
                GroupModel groupModel = Groups.newGroupModel(group);
                groupModel.setStatus("active");
                groupModels.put(groupKey, groupModel);
                routeRuleGroups.put((Object)routeRuleInfo.getRouteRule().getName().toLowerCase(), (Object)group);
            }
        }
        RouteRuleModel routeRuleFilter = new RouteRuleModel();
        routeRuleFilter.setServiceId(serviceId);
        for (RouteRuleModel routeRuleModel : this.routeRuleDao.select(routeRuleFilter)) {
            if (routeRuleGroups.containsKey((Object)routeRuleModel.getName().toLowerCase())) continue;
            routeRuleModel.setStatus("inactive");
            routeRuleModels.add(routeRuleModel);
        }
        GroupModel groupModel = new GroupModel();
        groupModel.setServiceId(serviceId);
        for (GroupModel groupModel2 : this.groupDao.select(groupModel)) {
            String groupKey = Groups.newGroup(groupModel2).getGroupKey();
            if (groupModels.containsKey(groupKey)) continue;
            groupModel2.setStatus("inactive");
            groupModels.put(groupKey, groupModel2);
        }
        this.insertOrUpdateRouteRules(operationContext, routeRuleModels);
        this.insertOrUpdateGroups(operationContext, Lists.newArrayList(groupModels.values()));
        List<RouteRuleGroupModel> list = this.getRouteRuleGroups(serviceId, (ListMultimap<String, GroupWeight>)routeRuleGroups);
        this.insertOrUpdateRouteRuleGroups(operationContext, list);
        this.releaseRouteRuleGroups(operationContext, list);
    }

    protected List<RouteRuleGroupModel> getRouteRuleGroups(String serviceId, ListMultimap<String, GroupWeight> routeRuleGroups) {
        RouteRuleModel routeRuleFilter = new RouteRuleModel();
        routeRuleFilter.setServiceId(serviceId);
        List<RouteRuleModel> newRouteRules = this.routeRuleDao.select(routeRuleFilter);
        GroupModel groupFilter = new GroupModel();
        groupFilter.setServiceId(serviceId);
        HashMap newGroups = Maps.newHashMap();
        for (Group group : Groups.newGroups(this.groupDao.select(groupFilter))) {
            newGroups.put(group.getGroupKey(), group.getGroupId());
        }
        ArrayList routeRuleGroupModels = Lists.newArrayList();
        for (RouteRuleModel routeRule : newRouteRules) {
            List groupWeights = routeRuleGroups.get((Object)routeRule.getName().toLowerCase());
            if (CollectionExtension.isEmpty((Collection)groupWeights)) continue;
            for (GroupWeight groupWeight : groupWeights) {
                String groupKey = groupWeight.getGroupKey();
                routeRuleGroupModels.add(new RouteRuleGroupModel(routeRule.getId(), (Long)newGroups.get(groupKey), groupWeight.getWeight()));
            }
        }
        return routeRuleGroupModels;
    }

    @Transactional
    public void operationGroupOperation(OperationContext operationContext, GroupModel group, boolean isOperationComplete) {
        this.checkOperationContextArgument(operationContext);
        ArrayList groupOperation = Lists.newArrayList((Object[])new GroupOperationModel[]{new GroupOperationModel(this.groupDao.generateGroup(group).getId(), operationContext.getOperation())});
        if (isOperationComplete) {
            this.deleteGroupOperation(operationContext, groupOperation);
        } else {
            this.insertOrUpdateGroupOperation(operationContext, groupOperation);
        }
    }

    public RouteRuleModel generateRouteRule(RouteRuleModel routeRuleModel) {
        return this.routeRuleDao.generateRouteRule(routeRuleModel);
    }

    public GroupModel generateGroup(GroupModel groupModel) {
        return this.groupDao.generateGroup(groupModel);
    }

    @Transactional
    public void updateGroupInstance(OperationContext operationContext, Long groupId, Set<String> instanceIds) {
        this.checkOperationContextArgument(operationContext);
        ArrayList newGroupInstances = Lists.newArrayList();
        ArrayList expireGroupInstanceIds = Lists.newArrayList();
        GroupInstanceModel filter = new GroupInstanceModel();
        filter.setGroupId(groupId);
        for (GroupInstanceModel groupInstanceModel : this.groupInstanceDao.select(filter)) {
            String instanceId = groupInstanceModel.getInstanceId();
            if (instanceIds.contains(instanceId)) {
                instanceIds.remove(instanceId);
                continue;
            }
            expireGroupInstanceIds.add(groupInstanceModel.getId());
        }
        for (String instanceId : instanceIds) {
            newGroupInstances.add(new GroupInstanceModel(groupId, instanceId));
        }
        if (!CollectionExtension.isEmpty((Collection)expireGroupInstanceIds)) {
            this.deleteGroupInstances(operationContext, expireGroupInstanceIds);
        }
        if (!CollectionExtension.isEmpty((Collection)newGroupInstances)) {
            this.insertGroupInstances(operationContext, newGroupInstances);
        }
    }

    public void deleteGroupOperation(OperationContext operationContext, List<GroupOperationModel> groupOperations) {
        this.checkOperationContextArgument(operationContext);
        this.groupOperationDao.delete(groupOperations);
        this.groupOperationLogDao.insert(GroupOperationsUtil.newGroupOperationLogModels(operationContext, groupOperations, true));
    }

    public void insertOrUpdateGroupOperation(OperationContext operationContext, List<GroupOperationModel> groupOperations) {
        this.checkOperationContextArgument(operationContext);
        this.groupOperationDao.insertOrUpdate(groupOperations);
        this.groupOperationLogDao.insert(GroupOperationsUtil.newGroupOperationLogModels(operationContext, groupOperations, false));
    }

    public void deleteGroups(OperationContext operationContext, List<Long> groupIds) {
        this.checkOperationContextArgument(operationContext);
        List<GroupModel> groups = this.groupDao.select(groupIds);
        this.groupDao.delete(groupIds);
        this.groupLogDao.insert(Groups.newGroupLogModels(operationContext, groups));
    }

    public void insertOrUpdateGroups(OperationContext operationContext, List<GroupModel> groups) {
        this.checkOperationContextArgument(operationContext);
        this.groupDao.insertOrUpdate(groups);
        this.groupLogDao.insert(Groups.newGroupLogModels(operationContext, groups));
    }

    public void insertGroups(OperationContext operationContext, List<GroupModel> groups) {
        this.checkOperationContextArgument(operationContext);
        this.groupDao.insert(groups);
        this.groupLogDao.insert(Groups.newGroupLogModels(operationContext, groups));
    }

    public void deleteRouteRules(OperationContext operationContext, List<Long> routeRuleIds) {
        this.checkOperationContextArgument(operationContext);
        List<RouteRuleModel> routeRules = this.routeRuleDao.select(routeRuleIds);
        this.routeRuleDao.delete(routeRuleIds);
        this.routeRuleLogDao.insert(ServiceRouteRules.newRouteRuleLogModels(operationContext, routeRules));
    }

    public void insertOrUpdateRouteRules(OperationContext operationContext, List<RouteRuleModel> routeRules) {
        this.checkOperationContextArgument(operationContext);
        this.routeRuleDao.insertOrUpdate(routeRules);
        this.routeRuleLogDao.insert(ServiceRouteRules.newRouteRuleLogModels(operationContext, routeRules));
    }

    public void insertRouteRules(OperationContext operationContext, List<RouteRuleModel> routeRules) {
        this.checkOperationContextArgument(operationContext);
        this.routeRuleDao.insert(routeRules);
        this.routeRuleLogDao.insert(ServiceRouteRules.newRouteRuleLogModels(operationContext, routeRules));
    }

    public void deleteRouteRuleGroups(OperationContext operationContext, List<Long> ids) {
        this.checkOperationContextArgument(operationContext);
        List<RouteRuleGroupModel> routeRuleGroups = this.routeRuleGroupDao.select(ids);
        this.routeRuleGroupDao.delete(ids);
        this.routeRuleGroupLogDao.insert(RouteRuleGroups.newRouteRuleGroupLogs(operationContext, routeRuleGroups));
    }

    public void insertOrUpdateRouteRuleGroups(OperationContext operationContext, List<RouteRuleGroupModel> routeRuleGroups) {
        this.checkOperationContextArgument(operationContext);
        this.routeRuleGroupDao.insertOrUpdate(routeRuleGroups);
        this.routeRuleGroupLogDao.insert(RouteRuleGroups.newRouteRuleGroupLogs(operationContext, routeRuleGroups));
    }

    public void releaseRouteRuleGroups(OperationContext operationContext, List<RouteRuleGroupModel> routeRuleGroups) {
        this.checkOperationContextArgument(operationContext);
        this.routeRuleGroupDao.release(routeRuleGroups);
        this.routeRuleGroupLogDao.insert(RouteRuleGroups.newRouteRuleGroupLogs(operationContext, routeRuleGroups));
    }

    public void publishRouteRuleGroups(OperationContext operationContext, List<RouteRuleGroupModel> routeRuleGroups) {
        this.checkOperationContextArgument(operationContext);
        this.routeRuleGroupDao.publish(routeRuleGroups);
        this.routeRuleGroupLogDao.insert(RouteRuleGroups.newRouteRuleGroupLogs(operationContext, routeRuleGroups));
    }

    public void deleteGroupInstances(OperationContext operationContext, List<Long> groupInstanceIds) {
        this.checkOperationContextArgument(operationContext);
        List<GroupInstanceModel> groupInstanceModels = this.groupInstanceDao.select(groupInstanceIds);
        this.groupInstanceDao.delete(groupInstanceIds);
        this.groupInstanceLogDao.insert(GroupInstances.newGroupLogModels(operationContext, groupInstanceModels));
    }

    public void deleteGroupInstancesByFilter(OperationContext operationContext, List<GroupInstanceModel> groupInstances) {
        this.checkOperationContextArgument(operationContext);
        this.groupInstanceDao.deleteByFilters(groupInstances);
        this.groupInstanceLogDao.insert(GroupInstances.newGroupLogModels(operationContext, groupInstances));
    }

    public void insertGroupInstances(OperationContext operationContext, List<GroupInstanceModel> groupInstanceModels) {
        this.checkOperationContextArgument(operationContext);
        this.groupInstanceDao.insert(groupInstanceModels);
        this.groupInstanceLogDao.insert(GroupInstances.newGroupLogModels(operationContext, groupInstanceModels));
    }

    public void deleteServiceInstances(OperationContext operationContext, List<Long> serviceInstanceIds) {
        this.checkOperationContextArgument(operationContext);
        List<ServiceInstanceModel> serviceInstanceModels = this.serviceInstanceDao.select(serviceInstanceIds);
        this.serviceInstanceDao.delete(serviceInstanceIds);
        this.serviceInstanceLogDao.insert(ServiceInstances.newServiceInstanceLogModels(operationContext, serviceInstanceModels));
    }

    public void deleteServiceInstancesByFilter(OperationContext operationContext, List<ServiceInstanceModel> serviceInstances) {
        this.checkOperationContextArgument(operationContext);
        this.serviceInstanceDao.deleteByFilters(serviceInstances);
        this.serviceInstanceLogDao.insert(ServiceInstances.newServiceInstanceLogModels(operationContext, serviceInstances));
    }

    public void insertServiceInstances(OperationContext operationContext, List<ServiceInstanceModel> serviceInstanceModels) {
        this.checkOperationContextArgument(operationContext);
        this.serviceInstanceDao.insertOrUpdate(serviceInstanceModels);
        this.serviceInstanceLogDao.insert(ServiceInstances.newServiceInstanceLogModels(operationContext, serviceInstanceModels));
    }

    protected void checkOperationContextArgument(OperationContext operationContext) {
        ValueCheckers.notNullOrWhiteSpace((String)operationContext.getOperation(), (String)"operation");
        ValueCheckers.notNullOrWhiteSpace((String)operationContext.getExtensions(), (String)"extensions");
        ValueCheckers.notNullOrWhiteSpace((String)operationContext.getOperatorId(), (String)"operatorId");
        ValueCheckers.notNullOrWhiteSpace((String)operationContext.getToken(), (String)"token");
    }

    protected void checkServiceRouteRules(String serviceId, List<RouteRuleInfo> routeRuleInfos) {
        ValueCheckers.notNullOrWhiteSpace((String)"serviceId", (String)serviceId);
        ValueCheckers.notNullOrEmpty(routeRuleInfos, (String)"routeRules");
        for (RouteRuleInfo info : routeRuleInfos) {
            ServiceRouteRule routeRule = info.getRouteRule();
            ValueCheckers.notNull((Object)routeRule, (String)"routeRule");
            Preconditions.checkArgument((boolean)serviceId.equalsIgnoreCase(routeRule.getServiceId()), (Object)("routeRule.serviceId not equals to: " + serviceId));
            ValueCheckers.notNullOrWhiteSpace((String)routeRule.getName(), (String)"routeRule.name");
            ValueCheckers.notNullOrWhiteSpace((String)routeRule.getStatus(), (String)"routeRule.status");
            ValueCheckers.notNullOrEmpty(info.getGroups(), (String)"groups");
            for (GroupWeight group : info.getGroups()) {
                ValueCheckers.notNull((Object)group.getWeight(), (String)"weight");
                ValueCheckers.notNull((Object)group, (String)"group");
                Preconditions.checkArgument((boolean)serviceId.equalsIgnoreCase(group.getServiceId()), (Object)("group.serviceId not equals to: " + serviceId));
                ValueCheckers.notNullOrWhiteSpace((String)group.getRegionId(), (String)"group.regionId");
                ValueCheckers.notNullOrWhiteSpace((String)group.getZoneId(), (String)"group.zoneId");
                ValueCheckers.notNullOrWhiteSpace((String)group.getName(), (String)"group.name");
                ValueCheckers.notNullOrWhiteSpace((String)group.getAppId(), (String)"group.appId");
                ValueCheckers.notNullOrWhiteSpace((String)group.getStatus(), (String)"group.status");
            }
        }
    }
}

