/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.group.dao;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.artemis.management.dao.DataConfig;
import org.mydotey.artemis.management.group.model.GroupModel;
import org.mydotey.java.StringExtension;
import org.mydotey.java.collection.CollectionExtension;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;

public class GroupDao {
    public static final GroupDao INSTANCE = new GroupDao();

    private GroupDao() {
    }

    protected GroupModel generateGroup(GroupModel group) {
        GroupModel filter = new GroupModel();
        filter.setServiceId(group.getServiceId());
        filter.setRegionId(group.getRegionId());
        filter.setZoneId(group.getZoneId());
        filter.setName(group.getName());
        List<GroupModel> newGroups = this.select(filter);
        if (newGroups.size() == 0) {
            this.insert(group);
            newGroups = this.select(filter);
        }
        return newGroups.get(0);
    }

    public List<GroupModel> query() {
        String sql = "SELECT id, service_id, region_id, zone_id, name, app_id, description,status from service_group where deleted = false";
        return DataConfig.jdbcTemplate().query("SELECT id, service_id, region_id, zone_id, name, app_id, description,status from service_group where deleted = false", (RowMapper)new RowMapper<GroupModel>(){

            public GroupModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                GroupModel group = new GroupModel();
                group.setId(rs.getLong(1));
                group.setServiceId(rs.getString(2));
                group.setRegionId(rs.getString(3));
                group.setZoneId(rs.getString(4));
                group.setName(rs.getString(5));
                group.setAppId(rs.getString(6));
                group.setDescription(rs.getString(7));
                group.setStatus(rs.getString(8));
                return group;
            }
        });
    }

    protected void delete(Long ... ids) {
        this.delete(Lists.newArrayList((Object[])ids));
    }

    protected void delete(final List<Long> ids) {
        ValueCheckers.notNullOrEmpty(ids, (String)"ids");
        DataConfig.jdbcTemplate().batchUpdate("update service_group set deleted = true where id = ?", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return ids.size();
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Long id = (Long)ids.get(i);
                if (id == null) {
                    ps.setLong(1, 0L);
                } else {
                    ps.setLong(1, id);
                }
            }
        });
    }

    protected void insertOrUpdate(GroupModel ... groups) {
        this.insertOrUpdate(Lists.newArrayList((Object[])groups));
    }

    protected void insertOrUpdate(final List<GroupModel> models) {
        this.checkInsertOrUpdateArgument(models);
        DataConfig.jdbcTemplate().batchUpdate("insert into service_group (service_id, region_id, zone_id, name, app_id, description,status) values (?,?,?,?,?,?,?) on duplicate key update app_id=?, description=?, status=?, deleted=false", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                GroupModel model = (GroupModel)models.get(i);
                ps.setString(1, model.getServiceId());
                ps.setString(2, model.getRegionId());
                ps.setString(3, model.getZoneId());
                ps.setString(4, model.getName());
                ps.setString(5, model.getAppId());
                ps.setString(6, model.getDescription());
                ps.setString(7, model.getStatus());
                ps.setString(8, model.getAppId());
                ps.setString(9, model.getDescription());
                ps.setString(10, model.getStatus());
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    protected void insert(GroupModel ... groups) {
        this.insert(Lists.newArrayList((Object[])groups));
    }

    protected void insert(final List<GroupModel> models) {
        this.checkInsertOrUpdateArgument(models);
        DataConfig.jdbcTemplate().batchUpdate("insert into service_group (service_id, region_id, zone_id, name, app_id, description,status) values (?,?,?,?,?,?,?) on duplicate key update deleted=false", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                GroupModel model = (GroupModel)models.get(i);
                ps.setString(1, model.getServiceId());
                ps.setString(2, model.getRegionId());
                ps.setString(3, model.getZoneId());
                ps.setString(4, model.getName());
                ps.setString(5, model.getAppId());
                ps.setString(6, model.getDescription());
                ps.setString(7, model.getStatus());
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    public List<GroupModel> select(GroupModel filter) {
        ValueCheckers.notNull((Object)filter, (String)"filter");
        HashMap conditions = Maps.newHashMap();
        conditions.put("id=?", filter.getId() == null ? null : Long.toString(filter.getId()));
        conditions.put("service_id=?", filter.getServiceId());
        conditions.put("region_id=?", filter.getRegionId());
        conditions.put("zone_id=?", filter.getZoneId());
        conditions.put("name=?", filter.getName());
        conditions.put("app_id=?", filter.getAppId());
        conditions.put("status=?", filter.getStatus());
        HashSet removed = Sets.newHashSet();
        for (String key : conditions.keySet()) {
            if (!StringExtension.isBlank((String)((String)conditions.get(key)))) continue;
            removed.add(key);
        }
        conditions.keySet().removeAll(removed);
        return this.query(Joiner.on((String)" and ").join(conditions.keySet()), Lists.newArrayList(conditions.values()));
    }

    public List<GroupModel> select(List<Long> groupIds) {
        if (CollectionExtension.isEmpty(groupIds)) {
            return Lists.newArrayList();
        }
        return this.query(String.format("id in (%s)", Joiner.on((char)',').join(groupIds)), new String[0]);
    }

    protected List<GroupModel> query(String condition, String ... args) {
        return this.query(condition, Lists.newArrayList((Object[])args));
    }

    protected List<GroupModel> query(final String condition, final List<String> args) {
        String sql = "SELECT id, service_id, region_id, zone_id, name, app_id, description, status, create_time,DataChange_LastTime from service_group where deleted = false";
        return DataConfig.jdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps;
                if (StringExtension.isBlank((String)condition)) {
                    ps = conn.prepareStatement("SELECT id, service_id, region_id, zone_id, name, app_id, description, status, create_time,DataChange_LastTime from service_group where deleted = false");
                } else {
                    ps = conn.prepareStatement(Joiner.on((String)" ").join((Object)"SELECT id, service_id, region_id, zone_id, name, app_id, description, status, create_time,DataChange_LastTime from service_group where deleted = false", (Object)"and", new Object[]{condition}));
                    for (int i = 0; i < args.size(); ++i) {
                        ps.setString(i + 1, (String)args.get(i));
                    }
                }
                return ps;
            }
        }, (RowMapper)new RowMapper<GroupModel>(){

            public GroupModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                GroupModel group = new GroupModel();
                group.setId(rs.getLong(1));
                group.setServiceId(rs.getString(2));
                group.setRegionId(rs.getString(3));
                group.setZoneId(rs.getString(4));
                group.setName(rs.getString(5));
                group.setAppId(rs.getString(6));
                group.setDescription(rs.getString(7));
                group.setStatus(rs.getString(8));
                group.setCreateTime(rs.getTimestamp(9));
                group.setUpdateTime(rs.getTimestamp(10));
                return group;
            }
        });
    }

    protected void checkInsertOrUpdateArgument(List<GroupModel> models) {
        ValueCheckers.notNullOrEmpty(models, (String)"models");
        for (GroupModel model : models) {
            ValueCheckers.notNull((Object)model, (String)"group");
            ValueCheckers.notNullOrWhiteSpace((String)model.getServiceId(), (String)"group.serviceId");
            ValueCheckers.notNullOrWhiteSpace((String)model.getRegionId(), (String)"group.regionId");
            ValueCheckers.notNullOrWhiteSpace((String)model.getZoneId(), (String)"group.zoneId");
            ValueCheckers.notNullOrWhiteSpace((String)model.getName(), (String)"group.name");
            ValueCheckers.notNullOrWhiteSpace((String)model.getAppId(), (String)"group.appId");
            ValueCheckers.notNullOrWhiteSpace((String)model.getStatus(), (String)"group.status");
        }
    }
}

