/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.group.dao;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.artemis.management.dao.DataConfig;
import org.mydotey.artemis.management.group.model.GroupInstanceModel;
import org.mydotey.java.StringExtension;
import org.mydotey.java.collection.CollectionExtension;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;

public class GroupInstanceDao {
    public static final GroupInstanceDao INSTANCE = new GroupInstanceDao();

    private GroupInstanceDao() {
    }

    public List<GroupInstanceModel> query() {
        String sql = "SELECT id, group_id, instance_id from service_group_instance";
        return DataConfig.jdbcTemplate().query("SELECT id, group_id, instance_id from service_group_instance", (RowMapper)new RowMapper<GroupInstanceModel>(){

            public GroupInstanceModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                GroupInstanceModel groupInstance = new GroupInstanceModel();
                groupInstance.setId(rs.getLong(1));
                groupInstance.setGroupId(rs.getLong(2));
                groupInstance.setInstanceId(rs.getString(3));
                return groupInstance;
            }
        });
    }

    protected void delete(Long ... ids) {
        this.delete(Lists.newArrayList((Object[])ids));
    }

    protected void delete(final List<Long> ids) {
        ValueCheckers.notNullOrEmpty(ids, (String)"ids");
        DataConfig.jdbcTemplate().batchUpdate("delete from service_group_instance where id = ?", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return ids.size();
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Long id = (Long)ids.get(i);
                if (id == null) {
                    ps.setLong(1, 0L);
                } else {
                    ps.setLong(1, id);
                }
            }
        });
    }

    protected void deleteByFilters(final List<GroupInstanceModel> filters) {
        this.checkInsertOrUpdateArgument(filters);
        DataConfig.jdbcTemplate().batchUpdate("delete from service_group_instance where group_id = ? and instance_id=?", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return filters.size();
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                GroupInstanceModel filter = (GroupInstanceModel)filters.get(i);
                ps.setLong(1, filter.getGroupId());
                ps.setString(2, filter.getInstanceId());
            }
        });
    }

    protected void insert(GroupInstanceModel ... groupInstances) {
        this.insert(Lists.newArrayList((Object[])groupInstances));
    }

    protected void insert(final List<GroupInstanceModel> models) {
        this.checkInsertOrUpdateArgument(models);
        DataConfig.jdbcTemplate().batchUpdate("insert ignore into service_group_instance (group_id, instance_id) values (?,?)", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                GroupInstanceModel model = (GroupInstanceModel)models.get(i);
                ps.setLong(1, model.getGroupId());
                ps.setString(2, model.getInstanceId());
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    public List<GroupInstanceModel> select(GroupInstanceModel filter) {
        ValueCheckers.notNull((Object)filter, (String)"filter");
        HashMap conditions = Maps.newHashMap();
        conditions.put("id=?", filter.getId() == null ? null : Long.toString(filter.getId()));
        conditions.put("group_id=?", filter.getGroupId() == null ? null : Long.toString(filter.getGroupId()));
        conditions.put("instance_id=?", filter.getInstanceId());
        HashSet removed = Sets.newHashSet();
        for (String key : conditions.keySet()) {
            if (!StringExtension.isBlank((String)((String)conditions.get(key)))) continue;
            removed.add(key);
        }
        conditions.keySet().removeAll(removed);
        return this.query(Joiner.on((String)" and ").join(conditions.keySet()), Lists.newArrayList(conditions.values()));
    }

    public List<GroupInstanceModel> select(List<Long> groupIds) {
        if (CollectionExtension.isEmpty(groupIds)) {
            return Lists.newArrayList();
        }
        return this.query(String.format("id in (%s)", Joiner.on((char)',').join(groupIds)), new String[0]);
    }

    protected List<GroupInstanceModel> query(String condition, String ... args) {
        return this.query(condition, Lists.newArrayList((Object[])args));
    }

    protected List<GroupInstanceModel> query(final String condition, final List<String> args) {
        String sql = "SELECT id, group_id, instance_id, create_time,DataChange_LastTime from service_group_instance";
        return DataConfig.jdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps;
                if (StringExtension.isBlank((String)condition)) {
                    ps = conn.prepareStatement("SELECT id, group_id, instance_id, create_time,DataChange_LastTime from service_group_instance");
                } else {
                    ps = conn.prepareStatement(Joiner.on((String)" ").join((Object)"SELECT id, group_id, instance_id, create_time,DataChange_LastTime from service_group_instance", (Object)"where", new Object[]{condition}));
                    for (int i = 0; i < args.size(); ++i) {
                        ps.setString(i + 1, (String)args.get(i));
                    }
                }
                return ps;
            }
        }, (RowMapper)new RowMapper<GroupInstanceModel>(){

            public GroupInstanceModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                GroupInstanceModel group = new GroupInstanceModel();
                group.setId(rs.getLong(1));
                group.setGroupId(rs.getLong(2));
                group.setInstanceId(rs.getString(3));
                group.setCreateTime(rs.getTimestamp(4));
                group.setUpdateTime(rs.getTimestamp(5));
                return group;
            }
        });
    }

    protected void checkInsertOrUpdateArgument(List<GroupInstanceModel> models) {
        ValueCheckers.notNullOrEmpty(models, (String)"models");
        for (GroupInstanceModel model : models) {
            ValueCheckers.notNull((Object)model, (String)"groupInstance");
            ValueCheckers.notNull((Object)model.getGroupId(), (String)"groupInstance.groupId");
            ValueCheckers.notNullOrWhiteSpace((String)model.getInstanceId(), (String)"groupInstance.instanceId");
        }
    }
}

