/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.group.dao;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.artemis.management.dao.DataConfig;
import org.mydotey.artemis.management.group.model.GroupOperationModel;
import org.mydotey.java.StringExtension;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;

public class GroupOperationDao {
    public static final GroupOperationDao INSTANCE = new GroupOperationDao();

    private GroupOperationDao() {
    }

    public List<GroupOperationModel> query() {
        return DataConfig.jdbcTemplate().query("select group_id, operation from service_group_operation", (RowMapper)new RowMapper<GroupOperationModel>(){

            public GroupOperationModel mapRow(ResultSet rs, int i) throws SQLException {
                GroupOperationModel groupOperation = new GroupOperationModel();
                groupOperation.setGroupId(rs.getLong(1));
                groupOperation.setOperation(rs.getString(2));
                return groupOperation;
            }
        });
    }

    protected void delete(GroupOperationModel groupOperation) {
        this.delete(Lists.newArrayList((Object[])new GroupOperationModel[]{groupOperation}));
    }

    protected void delete(final List<GroupOperationModel> groupOperations) {
        ValueCheckers.notNullOrEmpty(groupOperations, (String)"group operations");
        DataConfig.jdbcTemplate().batchUpdate("delete from service_group_operation where group_id =? and operation = ?", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                GroupOperationModel groupOperation = (GroupOperationModel)groupOperations.get(i);
                ps.setLong(1, groupOperation.getGroupId());
                ps.setString(2, groupOperation.getOperation());
            }

            public int getBatchSize() {
                return groupOperations.size();
            }
        });
    }

    protected void insertOrUpdate(GroupOperationModel ... operationModels) {
        this.insertOrUpdate(Lists.newArrayList((Object[])operationModels));
    }

    protected void insertOrUpdate(final List<GroupOperationModel> models) {
        this.checkInsertOrUpdateArgument(models);
        DataConfig.jdbcTemplate().batchUpdate("insert ignore into service_group_operation (group_id, operation) values (?,?)", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                GroupOperationModel groupOperation = (GroupOperationModel)models.get(i);
                ps.setLong(1, groupOperation.getGroupId());
                ps.setString(2, groupOperation.getOperation());
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    protected List<GroupOperationModel> query(final String condition, final List<String> args) {
        String sql = "SELECT id, group_id,operation,create_time,DataChange_LastTime from service_group_operation";
        return DataConfig.jdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps;
                if (StringExtension.isBlank((String)condition)) {
                    ps = conn.prepareStatement("SELECT id, group_id,operation,create_time,DataChange_LastTime from service_group_operation");
                } else {
                    ps = conn.prepareStatement(Joiner.on((String)" ").join((Object)"SELECT id, group_id,operation,create_time,DataChange_LastTime from service_group_operation", (Object)"where", new Object[]{condition}));
                    for (int i = 0; i < args.size(); ++i) {
                        ps.setString(i + 1, (String)args.get(i));
                    }
                }
                return ps;
            }
        }, (RowMapper)new RowMapper<GroupOperationModel>(){

            public GroupOperationModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                GroupOperationModel groupOperation = new GroupOperationModel();
                groupOperation.setId(rs.getLong(1));
                groupOperation.setGroupId(rs.getLong(2));
                groupOperation.setOperation(rs.getString(3));
                groupOperation.setCreateTime(rs.getTimestamp(4));
                groupOperation.setUpdateTime(rs.getTimestamp(5));
                return groupOperation;
            }
        });
    }

    private void checkInsertOrUpdateArgument(List<GroupOperationModel> models) {
        ValueCheckers.notNullOrEmpty(models, (String)"models");
        for (GroupOperationModel model : models) {
            ValueCheckers.notNull((Object)model, (String)"groupOperation");
            ValueCheckers.notNull((Object)model.getGroupId(), (String)"groupOperation.groupId");
            ValueCheckers.notNullOrWhiteSpace((String)model.getOperation(), (String)"groupOperation.operation");
        }
    }
}

