/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.group.dao;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.artemis.management.dao.DataConfig;
import org.mydotey.artemis.management.group.log.GroupOperationLog;
import org.mydotey.artemis.management.group.model.GroupOperationLogModel;
import org.mydotey.java.StringExtension;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

public class GroupOperationLogDao {
    public static final GroupOperationLogDao INSTANCE = new GroupOperationLogDao();

    private GroupOperationLogDao() {
    }

    public List<GroupOperationLog> select(GroupOperationLogModel filter, Boolean complete) {
        ValueCheckers.notNull((Object)filter, (String)"filter");
        HashMap conditions = Maps.newHashMap();
        conditions.put("group_id=?", filter.getGroupId());
        conditions.put("operation=?", filter.getOperation());
        conditions.put("operator_id=?", filter.getOperatorId());
        if (complete != null) {
            conditions.put("complete=?", complete != false ? "1" : "0");
        }
        HashSet removed = Sets.newHashSet();
        for (String key : conditions.keySet()) {
            Object value = conditions.get(key);
            if (value == null) {
                removed.add(key);
                continue;
            }
            if (!(value instanceof String) || !StringExtension.isBlank((String)((String)value))) continue;
            removed.add(key);
        }
        conditions.keySet().removeAll(removed);
        return this.query(Joiner.on((String)" and ").join(conditions.keySet()), Lists.newArrayList(conditions.values()));
    }

    public List<GroupOperationLog> query(final String condition, final List<Object> args) {
        String sql = "select id, group_id, operation, complete, operator_id, token, extensions, reason, create_time, datachange_lasttime from service_group_operation_log";
        return DataConfig.jdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps;
                if (StringExtension.isBlank((String)condition)) {
                    ps = conn.prepareStatement("select id, group_id, operation, complete, operator_id, token, extensions, reason, create_time, datachange_lasttime from service_group_operation_log");
                } else {
                    ps = conn.prepareStatement(Joiner.on((String)" ").join((Object)"select id, group_id, operation, complete, operator_id, token, extensions, reason, create_time, datachange_lasttime from service_group_operation_log", (Object)"where", new Object[]{condition}));
                    for (int i = 0; i < args.size(); ++i) {
                        ps.setObject(i + 1, args.get(i));
                    }
                }
                return ps;
            }
        }, (RowMapper)new RowMapper<GroupOperationLog>(){

            public GroupOperationLog mapRow(ResultSet rs, int arg1) throws SQLException {
                GroupOperationLog log = new GroupOperationLog();
                log.setId(rs.getLong(1));
                log.setGroupId(rs.getLong(2));
                log.setOperation(rs.getString(3));
                log.setComplete(rs.getBoolean(4));
                log.setOperatorId(rs.getString(5));
                log.setToken(rs.getString(6));
                log.setExtensions(rs.getString(7));
                log.setReason(rs.getString(8));
                log.setCreateTime(rs.getTimestamp(9));
                log.setUpdateTime(rs.getTimestamp(10));
                return log;
            }
        });
    }

    public void insert(GroupOperationLogModel ... logs) {
        if (logs == null || logs.length == 0) {
            return;
        }
        this.insert(Lists.newArrayList((Object[])logs));
    }

    public void insert(final List<GroupOperationLogModel> logs) {
        if (CollectionUtils.isEmpty(logs)) {
            return;
        }
        DataConfig.jdbcTemplate().batchUpdate("insert into service_group_operation_log (group_id, operation, complete, operator_id, token, extensions, reason) values (?,?,?,?,?,?,?)", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return logs.size();
            }

            public void setValues(PreparedStatement ps, int index) throws SQLException {
                GroupOperationLogModel log = (GroupOperationLogModel)logs.get(index);
                ps.setLong(1, log.getGroupId());
                ps.setString(2, log.getOperation());
                ps.setBoolean(3, log.isComplete());
                ps.setString(4, log.getOperatorId());
                ps.setString(5, log.getToken());
                ps.setString(6, log.getExtensions());
                ps.setString(7, log.getReason());
            }
        });
    }
}

