/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.group.dao;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.artemis.management.dao.DataConfig;
import org.mydotey.artemis.management.group.model.GroupTagModel;
import org.mydotey.java.StringExtension;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;

public class GroupTagDao {
    public static final GroupTagDao INSTANCE = new GroupTagDao();

    private GroupTagDao() {
    }

    public List<GroupTagModel> query() {
        return DataConfig.jdbcTemplate().query("select group_id, tag, value from service_group_tag", (RowMapper)new RowMapper<GroupTagModel>(){

            public GroupTagModel mapRow(ResultSet rs, int i) throws SQLException {
                GroupTagModel tag = new GroupTagModel();
                tag.setGroupId(rs.getLong(1));
                tag.setTag(rs.getString(2));
                tag.setValue(rs.getString(3));
                return tag;
            }
        });
    }

    public void delete(GroupTagModel filter) {
        ValueCheckers.notNull((Object)filter, (String)"filter");
        final HashMap conditions = Maps.newHashMap();
        conditions.put("group_id=?", filter.getGroupId() == null ? null : Long.toString(filter.getGroupId()));
        conditions.put("tag=?", filter.getTag());
        conditions.put("value=?", filter.getValue());
        HashSet removed = Sets.newHashSet();
        for (String key : conditions.keySet()) {
            if (!StringExtension.isBlank((String)((String)conditions.get(key)))) continue;
            removed.add(key);
        }
        conditions.keySet().removeAll(removed);
        if (conditions.size() == 0) {
            throw new IllegalStateException("forbidden operation.");
        }
        String sql = "delete from service_group_tag where " + Joiner.on((String)" and ").join(conditions.keySet());
        DataConfig.jdbcTemplate().update(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ArrayList args = Lists.newArrayList(conditions.values());
                for (int i = 0; i < args.size(); ++i) {
                    ps.setString(i + 1, (String)args.get(i));
                }
            }
        });
    }

    public void insertOrUpdate(GroupTagModel ... models) {
        this.insertOrUpdate(Lists.newArrayList((Object[])models));
    }

    public void insertOrUpdate(final List<GroupTagModel> models) {
        this.checkInsertOrUpdateArgument(models);
        DataConfig.jdbcTemplate().batchUpdate("insert into service_group_tag (group_id, tag, value) values (?,?,?) on duplicate key update value = ?", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                GroupTagModel model = (GroupTagModel)models.get(i);
                ps.setLong(1, model.getGroupId());
                ps.setString(2, model.getTag());
                ps.setString(3, model.getValue());
                ps.setString(4, model.getValue());
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    protected List<GroupTagModel> query(final String condition, final List<String> args) {
        String sql = "SELECT id, group_id, tag, value, create_time, DataChange_LastTime from service_group_tag";
        return DataConfig.jdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps;
                if (StringExtension.isBlank((String)condition)) {
                    ps = conn.prepareStatement("SELECT id, group_id, tag, value, create_time, DataChange_LastTime from service_group_tag");
                } else {
                    ps = conn.prepareStatement(Joiner.on((String)" ").join((Object)"SELECT id, group_id, tag, value, create_time, DataChange_LastTime from service_group_tag", (Object)"where", new Object[]{condition}));
                    for (int i = 0; i < args.size(); ++i) {
                        ps.setString(i + 1, (String)args.get(i));
                    }
                }
                return ps;
            }
        }, (RowMapper)new RowMapper<GroupTagModel>(){

            public GroupTagModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                GroupTagModel groupTag = new GroupTagModel();
                groupTag.setId(rs.getLong(1));
                groupTag.setGroupId(rs.getLong(2));
                groupTag.setTag(rs.getString(3));
                groupTag.setValue(rs.getString(4));
                groupTag.setCreateTime(rs.getTimestamp(5));
                groupTag.setUpdateTime(rs.getTimestamp(6));
                return groupTag;
            }
        });
    }

    private void checkInsertOrUpdateArgument(List<GroupTagModel> models) {
        ValueCheckers.notNullOrEmpty(models, (String)"models");
        for (GroupTagModel model : models) {
            ValueCheckers.notNull((Object)model, (String)"groupTag");
            ValueCheckers.notNull((Object)model.getGroupId(), (String)"groupTag.groupId");
            ValueCheckers.notNullOrWhiteSpace((String)model.getTag(), (String)"groupTag.tag");
            ValueCheckers.notNullOrWhiteSpace((String)model.getValue(), (String)"groupTag.value");
        }
    }
}

