/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.group.dao;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.artemis.management.dao.DataConfig;
import org.mydotey.artemis.management.group.model.RouteRuleModel;
import org.mydotey.java.StringExtension;
import org.mydotey.java.collection.CollectionExtension;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;

public class RouteRuleDao {
    public static final RouteRuleDao INSTANCE = new RouteRuleDao();

    public List<RouteRuleModel> query() {
        String sql = "SELECT id, service_id, name, description, status, strategy from service_route_rule where deleted = false";
        return DataConfig.jdbcTemplate().query("SELECT id, service_id, name, description, status, strategy from service_route_rule where deleted = false", (RowMapper)new RowMapper<RouteRuleModel>(){

            public RouteRuleModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                RouteRuleModel routeRule = new RouteRuleModel();
                routeRule.setId(rs.getLong(1));
                routeRule.setServiceId(rs.getString(2));
                routeRule.setName(rs.getString(3));
                routeRule.setDescription(rs.getString(4));
                routeRule.setStatus(rs.getString(5));
                routeRule.setStrategy(rs.getString(6));
                return routeRule;
            }
        });
    }

    protected RouteRuleModel generateRouteRule(RouteRuleModel routeRule) {
        this.insert(routeRule);
        RouteRuleModel filter = new RouteRuleModel();
        filter.setServiceId(routeRule.getServiceId());
        filter.setName(routeRule.getName());
        List<RouteRuleModel> newRouteRules = this.select(filter);
        if (newRouteRules.size() == 0) {
            this.insert(routeRule);
            newRouteRules = this.select(filter);
        }
        return newRouteRules.get(0);
    }

    protected void delete(Long ... ids) {
        this.delete(Lists.newArrayList((Object[])ids));
    }

    protected void delete(final List<Long> ids) {
        ValueCheckers.notNullOrEmpty(ids, (String)"ids");
        DataConfig.jdbcTemplate().batchUpdate("update service_route_rule set deleted = true where id = ?", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return ids.size();
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Long id = (Long)ids.get(i);
                if (id == null) {
                    ps.setLong(1, 0L);
                } else {
                    ps.setLong(1, id);
                }
            }
        });
    }

    protected void insertOrUpdate(RouteRuleModel ... models) {
        this.insertOrUpdate(Lists.newArrayList((Object[])models));
    }

    protected void insertOrUpdate(final List<RouteRuleModel> models) {
        this.checkInsertOrUpdateArgument(models);
        DataConfig.jdbcTemplate().batchUpdate("insert into service_route_rule (service_id, name, description, status, strategy) values (?,?,?,?,?) on duplicate key update description=?, status=?, strategy=?, deleted=false", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                RouteRuleModel model = (RouteRuleModel)models.get(i);
                Object[] params = new Object[]{model.getServiceId(), model.getName(), model.getDescription(), model.getStatus(), model.getStrategy(), model.getDescription(), model.getStatus(), model.getStrategy()};
                for (int index = 0; index < params.length; ++index) {
                    ps.setObject(index + 1, params[index]);
                }
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    protected void insert(RouteRuleModel ... models) {
        this.insert(Lists.newArrayList((Object[])models));
    }

    protected void insert(final List<RouteRuleModel> models) {
        this.checkInsertOrUpdateArgument(models);
        DataConfig.jdbcTemplate().batchUpdate("insert into service_route_rule (service_id, name, description, status, strategy) values (?,?,?,?,?) on duplicate key update deleted=false", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                RouteRuleModel model = (RouteRuleModel)models.get(i);
                ps.setString(1, model.getServiceId());
                ps.setString(2, model.getName());
                ps.setString(3, model.getDescription());
                ps.setString(4, model.getStatus());
                ps.setString(5, model.getStrategy());
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    public List<RouteRuleModel> select(RouteRuleModel filter) {
        ValueCheckers.notNull((Object)filter, (String)"filter");
        HashMap conditions = Maps.newHashMap();
        conditions.put("id=?", filter.getId() == null ? null : Long.toString(filter.getId()));
        conditions.put("service_id=?", filter.getServiceId());
        conditions.put("name=?", filter.getName());
        conditions.put("status=?", filter.getStatus());
        HashSet removed = Sets.newHashSet();
        for (String key : conditions.keySet()) {
            if (!StringExtension.isBlank((String)((String)conditions.get(key)))) continue;
            removed.add(key);
        }
        conditions.keySet().removeAll(removed);
        return this.query(Joiner.on((String)" and ").join(conditions.keySet()), Lists.newArrayList(conditions.values()));
    }

    public List<RouteRuleModel> select(List<Long> groupIds) {
        if (CollectionExtension.isEmpty(groupIds)) {
            return Lists.newArrayList();
        }
        return this.query(String.format("id in (%s)", Joiner.on((char)',').join(groupIds)), new String[0]);
    }

    protected List<RouteRuleModel> query(String condition, String ... args) {
        return this.query(condition, Lists.newArrayList((Object[])args));
    }

    protected List<RouteRuleModel> query(final String condition, final List<String> args) {
        String sql = "SELECT id, service_id, name, description,status, strategy, create_time,DataChange_LastTime from service_route_rule where deleted = false";
        return DataConfig.jdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps;
                if (StringExtension.isBlank((String)condition)) {
                    ps = conn.prepareStatement("SELECT id, service_id, name, description,status, strategy, create_time,DataChange_LastTime from service_route_rule where deleted = false");
                } else {
                    ps = conn.prepareStatement(Joiner.on((String)" ").join((Object)"SELECT id, service_id, name, description,status, strategy, create_time,DataChange_LastTime from service_route_rule where deleted = false", (Object)"and", new Object[]{condition}));
                    for (int i = 0; i < args.size(); ++i) {
                        ps.setString(i + 1, (String)args.get(i));
                    }
                }
                return ps;
            }
        }, (RowMapper)new RowMapper<RouteRuleModel>(){

            public RouteRuleModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                RouteRuleModel routeRule = new RouteRuleModel();
                routeRule.setId(rs.getLong(1));
                routeRule.setServiceId(rs.getString(2));
                routeRule.setName(rs.getString(3));
                routeRule.setDescription(rs.getString(4));
                routeRule.setStatus(rs.getString(5));
                routeRule.setStrategy(rs.getString(6));
                routeRule.setCreateTime(rs.getTimestamp(7));
                routeRule.setUpdateTime(rs.getTimestamp(8));
                return routeRule;
            }
        });
    }

    protected void checkInsertOrUpdateArgument(List<RouteRuleModel> models) {
        ValueCheckers.notNullOrEmpty(models, (String)"models");
        for (RouteRuleModel model : models) {
            this.checkInsertOrUpdateArgument(model);
        }
    }

    protected void checkInsertOrUpdateArgument(RouteRuleModel model) {
        ValueCheckers.notNull((Object)model, (String)"routeRule");
        ValueCheckers.notNullOrWhiteSpace((String)model.getServiceId(), (String)"routeRule.serviceId");
        ValueCheckers.notNullOrWhiteSpace((String)model.getName(), (String)"routeRule.name");
        ValueCheckers.notNullOrWhiteSpace((String)model.getStatus(), (String)"routeRule.status");
        ValueCheckers.notNullOrWhiteSpace((String)model.getStrategy(), (String)"routeRule.strategy");
    }
}

