/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.group.dao;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.artemis.management.dao.DataConfig;
import org.mydotey.artemis.management.group.model.RouteRuleGroupModel;
import org.mydotey.java.StringExtension;
import org.mydotey.java.collection.CollectionExtension;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;

public class RouteRuleGroupDao {
    public static final RouteRuleGroupDao INSTANCE = new RouteRuleGroupDao();

    public List<RouteRuleGroupModel> query() {
        String sql = "SELECT id, route_rule_id, group_id, weight, unreleased_weight from service_route_rule_group";
        return DataConfig.jdbcTemplate().query("SELECT id, route_rule_id, group_id, weight, unreleased_weight from service_route_rule_group", (RowMapper)new RowMapper<RouteRuleGroupModel>(){

            public RouteRuleGroupModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                RouteRuleGroupModel routeRuleGroup = new RouteRuleGroupModel();
                routeRuleGroup.setId(rs.getLong(1));
                routeRuleGroup.setRouteRuleId(rs.getLong(2));
                routeRuleGroup.setGroupId(rs.getLong(3));
                if (rs.getString(4) != null) {
                    routeRuleGroup.setWeight(rs.getInt(4));
                }
                if (rs.getString(5) != null) {
                    routeRuleGroup.setUnreleasedWeight(rs.getInt(5));
                }
                return routeRuleGroup;
            }
        });
    }

    public RouteRuleGroupModel generateGroup(RouteRuleGroupModel routeRuleGroup) {
        RouteRuleGroupModel filter = new RouteRuleGroupModel();
        filter.setGroupId(routeRuleGroup.getGroupId());
        List<RouteRuleGroupModel> newRouteRuleGroups = this.select(filter);
        if (newRouteRuleGroups.size() == 0) {
            this.insert(routeRuleGroup);
            newRouteRuleGroups = this.select(filter);
        }
        return newRouteRuleGroups.get(0);
    }

    protected void delete(Long ... ids) {
        this.delete(Lists.newArrayList((Object[])ids));
    }

    protected void delete(final List<Long> ids) {
        ValueCheckers.notNullOrEmpty(ids, (String)"ids");
        DataConfig.jdbcTemplate().batchUpdate("delete from service_route_rule_group where id = ?", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return ids.size();
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Long id = (Long)ids.get(i);
                if (id == null) {
                    ps.setLong(1, 0L);
                } else {
                    ps.setLong(1, id);
                }
            }
        });
    }

    protected void insertOrUpdate(RouteRuleGroupModel ... models) {
        this.insertOrUpdate(Lists.newArrayList((Object[])models));
    }

    protected void insertOrUpdate(final List<RouteRuleGroupModel> models) {
        this.checkInsertOrUpdateArgument(models);
        DataConfig.jdbcTemplate().batchUpdate("insert into service_route_rule_group (route_rule_id, group_id, unreleased_weight) values (?,?,?) on duplicate key update unreleased_weight=?", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                RouteRuleGroupModel model = (RouteRuleGroupModel)models.get(i);
                ps.setLong(1, model.getRouteRuleId());
                ps.setLong(2, model.getGroupId());
                Integer unreleasedWeight = model.getUnreleasedWeight();
                if (unreleasedWeight == null) {
                    ps.setString(3, null);
                    ps.setString(4, null);
                } else {
                    ps.setInt(3, unreleasedWeight);
                    ps.setInt(4, unreleasedWeight);
                }
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    protected void insert(RouteRuleGroupModel ... models) {
        this.insert(Lists.newArrayList((Object[])models));
    }

    protected void insert(final List<RouteRuleGroupModel> models) {
        this.checkInsertOrUpdateArgument(models);
        DataConfig.jdbcTemplate().batchUpdate("insert ignore into service_route_rule_group (route_rule_id, group_id, unreleased_weight) values (?,?,?)", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                RouteRuleGroupModel model = (RouteRuleGroupModel)models.get(i);
                ps.setLong(1, model.getRouteRuleId());
                ps.setLong(2, model.getGroupId());
                Integer unreleasedWeight = model.getUnreleasedWeight();
                if (unreleasedWeight == null) {
                    ps.setString(3, null);
                } else {
                    ps.setInt(3, unreleasedWeight);
                }
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    protected void release(final List<RouteRuleGroupModel> models) {
        this.checkReleaseArgument(models);
        DataConfig.jdbcTemplate().batchUpdate("update service_route_rule_group set weight = unreleased_weight where route_rule_id=? and group_id=?", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                RouteRuleGroupModel model = (RouteRuleGroupModel)models.get(i);
                ps.setLong(1, model.getRouteRuleId());
                ps.setLong(2, model.getGroupId());
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    protected void publish(RouteRuleGroupModel ... models) {
        this.publish(Lists.newArrayList((Object[])models));
    }

    protected void publish(final List<RouteRuleGroupModel> models) {
        this.checkInsertOrUpdateArgument(models);
        DataConfig.jdbcTemplate().batchUpdate("insert into service_route_rule_group (route_rule_id, group_id, weight) values (?,?,?) on duplicate key update weight=?", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                RouteRuleGroupModel model = (RouteRuleGroupModel)models.get(i);
                ps.setLong(1, model.getRouteRuleId());
                ps.setLong(2, model.getGroupId());
                Integer weight = model.getWeight();
                if (weight == null) {
                    ps.setString(3, null);
                    ps.setString(4, null);
                } else {
                    ps.setInt(3, weight);
                    ps.setInt(4, weight);
                }
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    public List<RouteRuleGroupModel> select(RouteRuleGroupModel filter) {
        ValueCheckers.notNull((Object)filter, (String)"filter");
        HashMap conditions = Maps.newHashMap();
        conditions.put("id=?", filter.getId());
        conditions.put("route_rule_id=?", filter.getRouteRuleId());
        conditions.put("group_id=?", filter.getGroupId());
        HashSet removed = Sets.newHashSet();
        for (String key : conditions.keySet()) {
            if (conditions.get(key) != null) continue;
            removed.add(key);
        }
        conditions.keySet().removeAll(removed);
        return this.query(Joiner.on((String)" and ").join(conditions.keySet()), Lists.newArrayList(conditions.values()));
    }

    public List<RouteRuleGroupModel> select(List<Long> groupIds) {
        if (CollectionExtension.isEmpty(groupIds)) {
            return Lists.newArrayList();
        }
        return this.query(String.format("id in (%s)", Joiner.on((char)',').join(groupIds)), new Long[0]);
    }

    protected List<RouteRuleGroupModel> query(String condition, Long ... args) {
        return this.query(condition, Lists.newArrayList((Object[])args));
    }

    protected List<RouteRuleGroupModel> query(final String condition, final List<Long> args) {
        String sql = "SELECT id, route_rule_id, group_id, weight,unreleased_weight, create_time,DataChange_LastTime from service_route_rule_group";
        return DataConfig.jdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps;
                if (StringExtension.isBlank((String)condition)) {
                    ps = conn.prepareStatement("SELECT id, route_rule_id, group_id, weight,unreleased_weight, create_time,DataChange_LastTime from service_route_rule_group");
                } else {
                    ps = conn.prepareStatement(Joiner.on((String)" ").join((Object)"SELECT id, route_rule_id, group_id, weight,unreleased_weight, create_time,DataChange_LastTime from service_route_rule_group", (Object)"where", new Object[]{condition}));
                    for (int i = 0; i < args.size(); ++i) {
                        ps.setLong(i + 1, (Long)args.get(i));
                    }
                }
                return ps;
            }
        }, (RowMapper)new RowMapper<RouteRuleGroupModel>(){

            public RouteRuleGroupModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                RouteRuleGroupModel routeRuleGroup = new RouteRuleGroupModel();
                routeRuleGroup.setId(rs.getLong(1));
                routeRuleGroup.setRouteRuleId(rs.getLong(2));
                routeRuleGroup.setGroupId(rs.getLong(3));
                if (rs.getString(4) != null) {
                    routeRuleGroup.setWeight(rs.getInt(4));
                }
                if (rs.getString(5) != null) {
                    routeRuleGroup.setUnreleasedWeight(rs.getInt(5));
                }
                routeRuleGroup.setCreateTime(rs.getTimestamp(6));
                routeRuleGroup.setUpdateTime(rs.getTimestamp(7));
                return routeRuleGroup;
            }
        });
    }

    private void checkInsertOrUpdateArgument(List<RouteRuleGroupModel> models) {
        ValueCheckers.notNullOrEmpty(models, (String)"models");
        for (RouteRuleGroupModel model : models) {
            ValueCheckers.notNull((Object)model, (String)"routeRuleGroup");
            ValueCheckers.notNull((Object)model.getRouteRuleId(), (String)"routeRuleGroup.routeRuleId");
            ValueCheckers.notNull((Object)model.getGroupId(), (String)"routeRuleGroup.groupId");
        }
    }

    private void checkReleaseArgument(List<RouteRuleGroupModel> models) {
        ValueCheckers.notNullOrEmpty(models, (String)"models");
        for (RouteRuleGroupModel model : models) {
            ValueCheckers.notNull((Object)model, (String)"routeRuleGroup");
            ValueCheckers.notNull((Object)model.getRouteRuleId(), (String)"routeRuleGroup.routeRuleId");
            ValueCheckers.notNull((Object)model.getGroupId(), (String)"routeRuleGroup.groupId");
        }
    }
}

