/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.group.dao;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.artemis.management.dao.DataConfig;
import org.mydotey.artemis.management.group.model.ServiceInstanceModel;
import org.mydotey.java.StringExtension;
import org.mydotey.java.collection.CollectionExtension;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;

public class ServiceInstanceDao {
    public static final ServiceInstanceDao INSTANCE = new ServiceInstanceDao();

    private ServiceInstanceDao() {
    }

    public List<ServiceInstanceModel> query() {
        String sql = "SELECT service_id, instance_id, ip, machine_name, metadata, port, protocol, region_id, zone_id, healthy_check_url, url, group_id from service_instance";
        return DataConfig.jdbcTemplate().query("SELECT service_id, instance_id, ip, machine_name, metadata, port, protocol, region_id, zone_id, healthy_check_url, url, group_id from service_instance", (RowMapper)new RowMapper<ServiceInstanceModel>(){

            public ServiceInstanceModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                ServiceInstanceModel serviceInstance = new ServiceInstanceModel();
                serviceInstance.setServiceId(rs.getString(1));
                serviceInstance.setInstanceId(rs.getString(2));
                serviceInstance.setIp(rs.getString(3));
                serviceInstance.setMachineName(rs.getString(4));
                serviceInstance.setMetadata(rs.getString(5));
                serviceInstance.setPort(rs.getInt(6));
                serviceInstance.setProtocol(rs.getString(7));
                serviceInstance.setRegionId(rs.getString(8));
                serviceInstance.setZoneId(rs.getString(9));
                serviceInstance.setHealthCheckUrl(rs.getString(10));
                serviceInstance.setUrl(rs.getString(11));
                serviceInstance.setGroupId(rs.getString(12));
                return serviceInstance;
            }
        });
    }

    protected void delete(Long ... ids) {
        this.delete(Lists.newArrayList((Object[])ids));
    }

    protected void delete(final List<Long> ids) {
        ValueCheckers.notNullOrEmpty(ids, (String)"ids");
        DataConfig.jdbcTemplate().batchUpdate("delete from service_instance where id = ?", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return ids.size();
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Long id = (Long)ids.get(i);
                if (id == null) {
                    ps.setLong(1, 0L);
                } else {
                    ps.setLong(1, id);
                }
            }
        });
    }

    protected void deleteByFilters(final List<ServiceInstanceModel> filters) {
        this.checkInsertOrUpdateArgument(filters);
        DataConfig.jdbcTemplate().batchUpdate("delete from service_instance where service_id = ? and instance_id=?", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return filters.size();
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ServiceInstanceModel filter = (ServiceInstanceModel)filters.get(i);
                ps.setString(1, filter.getServiceId());
                ps.setString(2, filter.getInstanceId());
            }
        });
    }

    protected void insertOrUpdate(ServiceInstanceModel ... groupInstances) {
        this.insertOrUpdate(Lists.newArrayList((Object[])groupInstances));
    }

    protected void insertOrUpdate(final List<ServiceInstanceModel> models) {
        this.checkInsertOrUpdateArgument(models);
        DataConfig.jdbcTemplate().batchUpdate("insert into service_instance (service_id, instance_id, ip, machine_name, metadata, port, protocol, region_id, zone_id, healthy_check_url, url, description, group_id) values (?,?,?,?,?,?,?,?,?,?,?,?,?) on duplicate key update  ip=?, machine_name=?, metadata=?, port=?, protocol=?, region_id=?, zone_id=?, healthy_check_url=?, url=?, description=?, group_id=?", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ServiceInstanceModel model = (ServiceInstanceModel)models.get(i);
                Object[] params = new Object[]{model.getServiceId(), model.getInstanceId(), model.getIp(), model.getMachineName(), model.getMetadata(), model.getPort(), model.getProtocol(), model.getRegionId(), model.getZoneId(), model.getHealthCheckUrl(), model.getUrl(), model.getDescription(), model.getGroupId(), model.getIp(), model.getMachineName(), model.getMetadata(), model.getPort(), model.getProtocol(), model.getRegionId(), model.getZoneId(), model.getHealthCheckUrl(), model.getUrl(), model.getDescription(), model.getGroupId()};
                for (int index = 0; index < params.length; ++index) {
                    ps.setObject(index + 1, params[index]);
                }
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    public List<ServiceInstanceModel> select(ServiceInstanceModel filter) {
        ValueCheckers.notNull((Object)filter, (String)"filter");
        HashMap conditions = Maps.newHashMap();
        conditions.put("service_id=?", filter.getServiceId());
        conditions.put("instance_id=?", filter.getInstanceId());
        HashSet removed = Sets.newHashSet();
        for (String key : conditions.keySet()) {
            if (!StringExtension.isBlank((String)((String)conditions.get(key)))) continue;
            removed.add(key);
        }
        conditions.keySet().removeAll(removed);
        return this.query(Joiner.on((String)" and ").join(conditions.keySet()), Lists.newArrayList(conditions.values()));
    }

    public List<ServiceInstanceModel> select(List<Long> groupIds) {
        if (CollectionExtension.isEmpty(groupIds)) {
            return Lists.newArrayList();
        }
        return this.query(String.format("id in (%s)", Joiner.on((char)',').join(groupIds)), new String[0]);
    }

    protected List<ServiceInstanceModel> query(String condition, String ... args) {
        return this.query(condition, Lists.newArrayList((Object[])args));
    }

    protected List<ServiceInstanceModel> query(final String condition, final List<String> args) {
        String sql = "SELECT id, service_id, instance_id, ip, machine_name, metadata, port, protocol, region_id, zone_id, healthy_check_url,url, description, group_id, create_time,DataChange_LastTime from service_instance";
        return DataConfig.jdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps;
                if (StringExtension.isBlank((String)condition)) {
                    ps = conn.prepareStatement("SELECT id, service_id, instance_id, ip, machine_name, metadata, port, protocol, region_id, zone_id, healthy_check_url,url, description, group_id, create_time,DataChange_LastTime from service_instance");
                } else {
                    ps = conn.prepareStatement(Joiner.on((String)" ").join((Object)"SELECT id, service_id, instance_id, ip, machine_name, metadata, port, protocol, region_id, zone_id, healthy_check_url,url, description, group_id, create_time,DataChange_LastTime from service_instance", (Object)"where", new Object[]{condition}));
                    for (int i = 0; i < args.size(); ++i) {
                        ps.setString(i + 1, (String)args.get(i));
                    }
                }
                return ps;
            }
        }, (RowMapper)new RowMapper<ServiceInstanceModel>(){

            public ServiceInstanceModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                ServiceInstanceModel serviceInstance = new ServiceInstanceModel();
                serviceInstance.setId(rs.getLong(1));
                serviceInstance.setServiceId(rs.getString(2));
                serviceInstance.setInstanceId(rs.getString(3));
                serviceInstance.setIp(rs.getString(4));
                serviceInstance.setMachineName(rs.getString(5));
                serviceInstance.setMetadata(rs.getString(6));
                serviceInstance.setPort(rs.getInt(7));
                serviceInstance.setProtocol(rs.getString(8));
                serviceInstance.setRegionId(rs.getString(9));
                serviceInstance.setZoneId(rs.getString(10));
                serviceInstance.setHealthCheckUrl(rs.getString(11));
                serviceInstance.setUrl(rs.getString(12));
                serviceInstance.setDescription(rs.getString(13));
                serviceInstance.setGroupId(rs.getString(14));
                serviceInstance.setCreateTime(rs.getTimestamp(15));
                serviceInstance.setUpdateTime(rs.getTimestamp(16));
                return serviceInstance;
            }
        });
    }

    protected void checkInsertOrUpdateArgument(List<ServiceInstanceModel> models) {
        ValueCheckers.notNullOrEmpty(models, (String)"models");
        for (ServiceInstanceModel model : models) {
            ValueCheckers.notNull((Object)model, (String)"serviceInstance");
            ValueCheckers.notNull((Object)model.getServiceId(), (String)"serviceInstance.serviceId");
            ValueCheckers.notNullOrWhiteSpace((String)model.getInstanceId(), (String)"serviceInstance.instanceId");
            ValueCheckers.notNullOrWhiteSpace((String)model.getUrl(), (String)"serviceInstance.url");
            ValueCheckers.notNullOrWhiteSpace((String)model.getIp(), (String)"serviceInstance.ip");
            ValueCheckers.notNullOrWhiteSpace((String)model.getMachineName(), (String)"serviceInstance.machineName");
            ValueCheckers.notNullOrWhiteSpace((String)model.getMetadata(), (String)"serviceInstance.metadata");
            ValueCheckers.notNullOrWhiteSpace((String)model.getProtocol(), (String)"serviceInstance.protocol");
            ValueCheckers.notNullOrWhiteSpace((String)model.getRegionId(), (String)"serviceInstance.regionId");
            ValueCheckers.notNullOrWhiteSpace((String)model.getZoneId(), (String)"serviceInstance.zoneId");
            ValueCheckers.notNullOrWhiteSpace((String)model.getHealthCheckUrl(), (String)"serviceInstance.healthCheckUrl");
            ValueCheckers.notNullOrWhiteSpace((String)model.getGroupId(), (String)"serviceInstance.groupId");
        }
    }
}

