/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.group.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.mydotey.artemis.management.common.OperationContext;
import org.mydotey.artemis.management.group.Group;
import org.mydotey.artemis.management.group.model.GroupLogModel;
import org.mydotey.artemis.management.group.model.GroupModel;
import org.mydotey.artemis.management.group.util.Converts;
import org.mydotey.java.collection.CollectionExtension;

public class Groups {
    public static Group newGroup(GroupModel model) {
        return new Group(model.getId(), model.getServiceId(), model.getRegionId(), model.getZoneId(), model.getName(), model.getAppId(), model.getDescription(), model.getStatus(), null);
    }

    public static GroupModel newGroupModel(Group group) {
        return new GroupModel(group.getServiceId(), group.getRegionId(), group.getZoneId(), group.getName(), group.getAppId(), group.getDescription(), group.getStatus());
    }

    public static List<GroupModel> newGroupModels(List<Group> groups) {
        return Converts.convert(groups, group -> Groups.newGroupModel(group));
    }

    public static List<Group> newGroups(List<GroupModel> models) {
        return Converts.convert(models, model -> Groups.newGroup(model));
    }

    public static List<GroupLogModel> newGroupLogModels(OperationContext operationContext, List<GroupModel> groups) {
        ArrayList logs = Lists.newArrayList();
        if (operationContext == null || CollectionExtension.isEmpty(groups)) {
            return logs;
        }
        for (GroupModel group : groups) {
            if (group == null) continue;
            logs.add(new GroupLogModel(group, operationContext));
        }
        return logs;
    }
}

