/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.group.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mydotey.artemis.management.common.OperationContext;
import org.mydotey.artemis.management.group.ServiceInstance;
import org.mydotey.artemis.management.group.model.ServiceInstanceLogModel;
import org.mydotey.artemis.management.group.model.ServiceInstanceModel;
import org.mydotey.artemis.management.group.util.Converts;
import org.mydotey.artemis.util.StringUtil;
import org.mydotey.codec.json.JacksonJsonCodec;
import org.mydotey.java.StringExtension;
import org.mydotey.java.collection.CollectionExtension;

public class ServiceInstances {
    public static ServiceInstance newServiceInstance(ServiceInstanceModel model) {
        Map metadata = Maps.newHashMap();
        if (!StringExtension.isBlank((String)model.getMetadata())) {
            try {
                metadata = (Map)JacksonJsonCodec.DEFAULT.decode(model.getMetadata().getBytes(), metadata.getClass());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new ServiceInstance(model.getId(), model.getServiceId(), model.getInstanceId(), model.getIp(), model.getMachineName(), metadata, model.getPort(), model.getProtocol(), model.getRegionId(), model.getZoneId(), model.getHealthCheckUrl(), model.getUrl(), model.getDescription(), model.getGroupId());
    }

    public static ServiceInstanceModel newServiceInstanceModel(ServiceInstance serviceInstance) {
        String metadata = "";
        if (serviceInstance.getMetadata() != null) {
            metadata = StringUtil.toJson(serviceInstance.getMetadata());
        }
        return new ServiceInstanceModel(serviceInstance.getServiceId(), serviceInstance.getInstanceId(), serviceInstance.getIp(), serviceInstance.getMachineName(), metadata, serviceInstance.getPort(), serviceInstance.getProtocol(), serviceInstance.getRegionId(), serviceInstance.getZoneId(), serviceInstance.getHealthCheckUrl(), serviceInstance.getUrl(), serviceInstance.getDescription(), serviceInstance.getGroupId());
    }

    public static List<ServiceInstanceModel> newServiceInstanceModels(List<ServiceInstance> groupInstances) {
        return Converts.convert(groupInstances, serviceInstance -> ServiceInstances.newServiceInstanceModel(serviceInstance));
    }

    public static List<ServiceInstance> newServiceInstances(List<ServiceInstanceModel> models) {
        return Converts.convert(models, model -> ServiceInstances.newServiceInstance(model));
    }

    public static List<ServiceInstanceLogModel> newServiceInstanceLogModels(OperationContext operationContext, List<ServiceInstanceModel> groupInstances) {
        ArrayList logs = Lists.newArrayList();
        if (operationContext == null || CollectionExtension.isEmpty(groupInstances)) {
            return logs;
        }
        for (ServiceInstanceModel ServiceInstance2 : groupInstances) {
            if (ServiceInstance2 == null) continue;
            logs.add(new ServiceInstanceLogModel(operationContext, ServiceInstance2));
        }
        return logs;
    }
}

