/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.util;

import org.mydotey.artemis.InstanceKey;
import org.mydotey.artemis.ServerKey;
import org.mydotey.artemis.management.dao.InstanceModel;
import org.mydotey.artemis.management.dao.ServerModel;
import org.mydotey.artemis.management.util.CheckResult;
import org.mydotey.java.StringExtension;

public class ModelUtil {
    private ModelUtil() {
    }

    public static CheckResult check(InstanceModel instance) {
        if (StringExtension.isBlank((String)instance.getRegionId())) {
            return new CheckResult(false, "regionId is null or empty");
        }
        if (StringExtension.isBlank((String)instance.getServiceId())) {
            return new CheckResult(false, "serviceId is null or empty");
        }
        if (StringExtension.isBlank((String)instance.getInstanceId())) {
            return new CheckResult(false, "instanceId is null or empty");
        }
        if (StringExtension.isBlank((String)instance.getOperation())) {
            return new CheckResult(false, "operation is null or empty");
        }
        if (StringExtension.isBlank((String)instance.getOperatorId())) {
            return new CheckResult(false, "operatorId is null or empty");
        }
        return new CheckResult(true, null);
    }

    public static CheckResult check(ServerModel server) {
        if (StringExtension.isBlank((String)server.getRegionId())) {
            return new CheckResult(false, "regionId is null or empty");
        }
        if (StringExtension.isBlank((String)server.getServerId())) {
            return new CheckResult(false, "serverId is null or empty");
        }
        if (StringExtension.isBlank((String)server.getOperation())) {
            return new CheckResult(false, "operation is null or empty");
        }
        if (StringExtension.isBlank((String)server.getOperatorId())) {
            return new CheckResult(false, "operatorId is null or empty");
        }
        return new CheckResult(true, null);
    }

    public static InstanceModel newInstance(InstanceKey instanceKey, String operation, String operatorId, String token) {
        return ModelUtil.newInstance(instanceKey.getRegionId(), instanceKey.getServiceId(), instanceKey.getInstanceId(), operation, operatorId, token);
    }

    public static InstanceModel newInstance(String regionId, String serviceId, String instanceId, String operation, String operatorId, String token) {
        regionId = StringExtension.trim((String)regionId, (char[])new char[0]);
        serviceId = StringExtension.trim((String)serviceId, (char[])new char[0]);
        instanceId = StringExtension.trim((String)instanceId, (char[])new char[0]);
        operation = StringExtension.trim((String)operation, (char[])new char[0]);
        operatorId = StringExtension.trim((String)operatorId, (char[])new char[0]);
        token = StringExtension.trim((String)token, (char[])new char[0]);
        return new InstanceModel(regionId, serviceId, instanceId, operation, operatorId, token);
    }

    public static ServerModel newServer(ServerKey serverKey, String operation, String operatorId, String token) {
        return ModelUtil.newServer(serverKey.getRegionId(), serverKey.getServerId(), operation, operatorId, token);
    }

    public static ServerModel newServer(String regionId, String serverId, String operation, String operatorId, String token) {
        regionId = StringExtension.trim((String)regionId, (char[])new char[0]);
        serverId = StringExtension.trim((String)serverId, (char[])new char[0]);
        operation = StringExtension.trim((String)operation, (char[])new char[0]);
        operatorId = StringExtension.trim((String)operatorId, (char[])new char[0]);
        token = StringExtension.trim((String)token, (char[])new char[0]);
        return new ServerModel(regionId, serverId, operation, operatorId, token);
    }
}

