/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.zone;

import com.google.common.base.Objects;
import org.mydotey.artemis.Instance;

public class ZoneKey {
    public static final ZoneKey EMPTY = new ZoneKey(null, null, null){

        @Override
        public void setRegionId(String regionId) {
            throw new IllegalStateException("EMPTY ZoneKey cannot be modified.");
        }

        @Override
        public void setServiceId(String serviceId) {
            throw new IllegalStateException("EMPTY ZoneKey cannot be modified.");
        }

        @Override
        public void setZoneId(String serviceId) {
            throw new IllegalStateException("EMPTY ZoneKey cannot be modified.");
        }
    };
    private String regionId;
    private String serviceId;
    private String zoneId;

    public static ZoneKey of(Instance instance) {
        if (instance == null) {
            return EMPTY;
        }
        return new ZoneKey(instance.getRegionId(), instance.getServiceId(), instance.getZoneId());
    }

    public ZoneKey() {
    }

    public ZoneKey(String regionId, String serviceId, String zoneId) {
        this.regionId = regionId;
        this.serviceId = serviceId;
        this.zoneId = zoneId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public String toString() {
        return String.format("%s.%s.%s", this.regionId, this.serviceId, this.zoneId).toLowerCase();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return Objects.equal((Object)this.toString(), (Object)other.toString());
    }
}

