/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.zone.dao;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.artemis.management.dao.DataConfig;
import org.mydotey.artemis.management.zone.model.ZoneOperationModel;
import org.mydotey.java.StringExtension;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;

public class ZoneOperationDao {
    public static final ZoneOperationDao INSTANCE = new ZoneOperationDao();

    private ZoneOperationDao() {
    }

    public List<ZoneOperationModel> query() {
        return DataConfig.jdbcTemplate().query("select service_id, region_id, zone_id, operation from service_zone", (RowMapper)new RowMapper<ZoneOperationModel>(){

            public ZoneOperationModel mapRow(ResultSet rs, int i) throws SQLException {
                ZoneOperationModel zoneOperation = new ZoneOperationModel();
                zoneOperation.setServiceId(rs.getString(1));
                zoneOperation.setRegionId(rs.getString(2));
                zoneOperation.setZoneId(rs.getString(3));
                zoneOperation.setOperation(rs.getString(4));
                return zoneOperation;
            }
        });
    }

    public void delete(ZoneOperationModel ... zoneOperations) {
        this.delete(Lists.newArrayList((Object[])zoneOperations));
    }

    public void delete(final List<ZoneOperationModel> zoneOperations) {
        ValueCheckers.notNullOrEmpty(zoneOperations, (String)"group operations");
        DataConfig.jdbcTemplate().batchUpdate("delete from service_zone where service_id =? and region_id=? and zone_id=? and operation = ?", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ZoneOperationModel zoneOperation = (ZoneOperationModel)zoneOperations.get(i);
                ps.setString(1, zoneOperation.getServiceId());
                ps.setString(2, zoneOperation.getRegionId());
                ps.setString(3, zoneOperation.getZoneId());
                ps.setString(4, zoneOperation.getOperation());
            }

            public int getBatchSize() {
                return zoneOperations.size();
            }
        });
    }

    public void insertOrUpdate(ZoneOperationModel ... operationModels) {
        this.insertOrUpdate(Lists.newArrayList((Object[])operationModels));
    }

    public void insertOrUpdate(final List<ZoneOperationModel> models) {
        this.checkInsertOrUpdateArgument(models);
        DataConfig.jdbcTemplate().batchUpdate("insert ignore into service_zone (service_id, region_id, zone_id, operation) values (?,?,?,?)", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ZoneOperationModel zoneOperation = (ZoneOperationModel)models.get(i);
                ps.setString(1, zoneOperation.getServiceId());
                ps.setString(2, zoneOperation.getRegionId());
                ps.setString(3, zoneOperation.getZoneId());
                ps.setString(4, zoneOperation.getOperation());
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    public List<ZoneOperationModel> select(ZoneOperationModel filter) {
        ValueCheckers.notNull((Object)filter, (String)"filter");
        HashMap conditions = Maps.newHashMap();
        conditions.put("id=?", filter.getId() == null ? null : Long.toString(filter.getId()));
        conditions.put("service_id=?", filter.getServiceId());
        conditions.put("region_id=?", filter.getRegionId());
        conditions.put("zone_id=?", filter.getZoneId());
        conditions.put("operation=?", filter.getOperation());
        HashSet removed = Sets.newHashSet();
        for (String key : conditions.keySet()) {
            if (!StringExtension.isBlank((String)((String)conditions.get(key)))) continue;
            removed.add(key);
        }
        conditions.keySet().removeAll(removed);
        return this.query(Joiner.on((String)" and ").join(conditions.keySet()), Lists.newArrayList(conditions.values()));
    }

    protected List<ZoneOperationModel> query(String condition, String ... args) {
        return this.query(condition, Lists.newArrayList((Object[])args));
    }

    protected List<ZoneOperationModel> query(final String condition, final List<String> args) {
        String sql = "SELECT id, service_id, region_id, zone_Id,operation,create_time,DataChange_LastTime from service_zone";
        return DataConfig.jdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps;
                if (StringExtension.isBlank((String)condition)) {
                    ps = conn.prepareStatement("SELECT id, service_id, region_id, zone_Id,operation,create_time,DataChange_LastTime from service_zone");
                } else {
                    ps = conn.prepareStatement(Joiner.on((String)" ").join((Object)"SELECT id, service_id, region_id, zone_Id,operation,create_time,DataChange_LastTime from service_zone", (Object)"where", new Object[]{condition}));
                    for (int i = 0; i < args.size(); ++i) {
                        ps.setString(i + 1, (String)args.get(i));
                    }
                }
                return ps;
            }
        }, (RowMapper)new RowMapper<ZoneOperationModel>(){

            public ZoneOperationModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                ZoneOperationModel zoneOperation = new ZoneOperationModel();
                zoneOperation.setId(rs.getLong(1));
                zoneOperation.setServiceId(rs.getString(2));
                zoneOperation.setRegionId(rs.getString(3));
                zoneOperation.setZoneId(rs.getString(4));
                zoneOperation.setOperation(rs.getString(5));
                zoneOperation.setCreateTime(rs.getTimestamp(6));
                zoneOperation.setUpdateTime(rs.getTimestamp(7));
                return zoneOperation;
            }
        });
    }

    private void checkInsertOrUpdateArgument(List<ZoneOperationModel> models) {
        ValueCheckers.notNullOrEmpty(models, (String)"models");
        for (ZoneOperationModel model : models) {
            ValueCheckers.notNull((Object)model, (String)"zoneOperation");
            ValueCheckers.notNullOrWhiteSpace((String)model.getServiceId(), (String)"zoneOperation.serviceId");
            ValueCheckers.notNullOrWhiteSpace((String)model.getRegionId(), (String)"zoneOperation.regionId");
            ValueCheckers.notNullOrWhiteSpace((String)model.getZoneId(), (String)"zoneOperation.zoneId");
            ValueCheckers.notNullOrWhiteSpace((String)model.getOperation(), (String)"zoneOperation.operation");
        }
    }
}

