/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.zone.dao;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.artemis.management.dao.DataConfig;
import org.mydotey.artemis.management.log.ZoneOperationLog;
import org.mydotey.artemis.management.zone.model.ZoneOperationLogModel;
import org.mydotey.java.StringExtension;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

public class ZoneOperationLogDao {
    public static final ZoneOperationLogDao INSTANCE = new ZoneOperationLogDao();

    private ZoneOperationLogDao() {
    }

    public List<ZoneOperationLog> select(ZoneOperationLogModel filter, Boolean complete) {
        ValueCheckers.notNull((Object)filter, (String)"filter");
        HashMap conditions = Maps.newHashMap();
        conditions.put("service_id=?", filter.getServiceId());
        conditions.put("region_id=?", filter.getRegionId());
        conditions.put("zone_id=?", filter.getZoneId());
        conditions.put("operation=?", filter.getOperation());
        conditions.put("operator_id=?", filter.getOperatorId());
        if (complete != null) {
            conditions.put("complete=?", complete != false ? "1" : "0");
        }
        HashSet removed = Sets.newHashSet();
        for (String key : conditions.keySet()) {
            if (!StringExtension.isBlank((String)((String)conditions.get(key)))) continue;
            removed.add(key);
        }
        conditions.keySet().removeAll(removed);
        return this.query(Joiner.on((String)" and ").join(conditions.keySet()), Lists.newArrayList(conditions.values()));
    }

    public List<ZoneOperationLog> query(final String condition, final List<String> args) {
        String sql = "select id, region_id, service_id, zone_id, operation, operator_id, token, complete, create_time, datachange_lasttime from service_zone_log";
        return DataConfig.jdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps;
                if (StringExtension.isBlank((String)condition)) {
                    ps = conn.prepareStatement("select id, region_id, service_id, zone_id, operation, operator_id, token, complete, create_time, datachange_lasttime from service_zone_log");
                } else {
                    ps = conn.prepareStatement(Joiner.on((String)" ").join((Object)"select id, region_id, service_id, zone_id, operation, operator_id, token, complete, create_time, datachange_lasttime from service_zone_log", (Object)"where", new Object[]{condition}));
                    for (int i = 0; i < args.size(); ++i) {
                        ps.setString(i + 1, (String)args.get(i));
                    }
                }
                return ps;
            }
        }, (RowMapper)new RowMapper<ZoneOperationLog>(){

            public ZoneOperationLog mapRow(ResultSet rs, int arg1) throws SQLException {
                ZoneOperationLog log = new ZoneOperationLog();
                log.setId(rs.getLong(1));
                log.setRegionId(rs.getString(2));
                log.setServiceId(rs.getString(3));
                log.setZoneId(rs.getString(4));
                log.setOperation(rs.getString(5));
                log.setOperatorId(rs.getString(6));
                log.setToken(rs.getString(7));
                log.setComplete(rs.getBoolean(8));
                log.setCreateTime(rs.getTimestamp(9));
                log.setUpdateTime(rs.getTimestamp(10));
                return log;
            }
        });
    }

    public void insert(ZoneOperationLogModel ... logs) {
        if (logs == null || logs.length == 0) {
            return;
        }
        this.insert(Lists.newArrayList((Object[])logs));
    }

    public void insert(final List<ZoneOperationLogModel> logs) {
        if (CollectionUtils.isEmpty(logs)) {
            return;
        }
        DataConfig.jdbcTemplate().batchUpdate("insert into service_zone_log (region_id, service_id, zone_id, operation, operator_id, token, complete) values (?,?,?,?,?,?,?)", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return logs.size();
            }

            public void setValues(PreparedStatement ps, int index) throws SQLException {
                ZoneOperationLogModel log = (ZoneOperationLogModel)logs.get(index);
                ps.setString(1, log.getRegionId());
                ps.setString(2, log.getServiceId());
                ps.setString(3, log.getZoneId());
                ps.setString(4, log.getOperation());
                ps.setString(5, log.getOperatorId());
                ps.setString(6, log.getToken());
                ps.setBoolean(7, log.isComplete());
            }
        });
    }
}

