/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.kbear.client;

import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.mydotey.java.ObjectExtension;
import org.mydotey.kbear.client.ConsumerProxy;
import org.mydotey.kbear.client.KafkaClientFactory;
import org.mydotey.kbear.client.KafkaConsumerConfig;
import org.mydotey.kbear.client.KafkaMetaManager;
import org.mydotey.kbear.client.KafkaProducerConfig;
import org.mydotey.kbear.client.ProducerProxy;
import org.mydotey.scf.ConfigurationManager;

public class DefaultKafkaClientFactory
implements KafkaClientFactory {
    private ConfigurationManager _configurationManager;
    private KafkaMetaManager _metaManager;

    public DefaultKafkaClientFactory(ConfigurationManager configurationManager, KafkaMetaManager metaManager) {
        ObjectExtension.requireNonNull((Object)configurationManager, (String)"configurationManager");
        ObjectExtension.requireNonNull((Object)metaManager, (String)"metaManager");
        this._configurationManager = configurationManager;
        this._metaManager = metaManager;
    }

    protected ConfigurationManager getConfigurationManager() {
        return this._configurationManager;
    }

    protected KafkaMetaManager getMetaManager() {
        return this._metaManager;
    }

    @Override
    public <K, V> Consumer<K, V> newConsumer(Map<String, Object> configs) {
        return this.newConsumer(configs, null, null);
    }

    @Override
    public <K, V> Consumer<K, V> newConsumer(Map<String, Object> configs, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        ObjectExtension.requireNonNull(configs, (String)"configs");
        Properties properties = new Properties();
        properties.putAll(configs);
        return this.newConsumer(properties, keyDeserializer, valueDeserializer);
    }

    @Override
    public <K, V> Consumer<K, V> newConsumer(Properties properties) {
        return this.newConsumer(properties, (Deserializer<K>)null, (Deserializer<V>)null);
    }

    @Override
    public <K, V> Consumer<K, V> newConsumer(Properties properties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        ObjectExtension.requireNonNull((Object)properties, (String)"properties");
        KafkaConsumerConfig kafkaConsumerConfig = new KafkaConsumerConfig.Builder().setProperties(properties).setKeyDeserializer(keyDeserializer).setValueDeserializer(valueDeserializer).build();
        return this.newConsumer(kafkaConsumerConfig);
    }

    @Override
    public <K, V> Consumer<K, V> newConsumer(KafkaConsumerConfig<K, V> kafkaConsumerConfig) {
        ObjectExtension.requireNonNull(kafkaConsumerConfig, (String)"kafkaConsumerConfig");
        return new ConsumerProxy(this._configurationManager, this._metaManager, (KafkaConsumerConfig)kafkaConsumerConfig.clone());
    }

    @Override
    public <K, V> Producer<K, V> newProducer(Map<String, Object> configs) {
        return this.newProducer(configs, null, null);
    }

    @Override
    public <K, V> Producer<K, V> newProducer(Map<String, Object> configs, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        ObjectExtension.requireNonNull(configs, (String)"configs");
        Properties properties = new Properties();
        properties.putAll(configs);
        return this.newProducer(properties, keySerializer, valueSerializer);
    }

    @Override
    public <K, V> Producer<K, V> newProducer(Properties properties) {
        return this.newProducer(properties, (Serializer<K>)null, (Serializer<V>)null);
    }

    @Override
    public <K, V> Producer<K, V> newProducer(Properties properties, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        ObjectExtension.requireNonNull((Object)properties, (String)"properties");
        KafkaProducerConfig kafkaProducerConfig = new KafkaProducerConfig.Builder().setProperties(properties).setKeySerializer(keySerializer).setValueSerializer(valueSerializer).build();
        return this.newProducer(kafkaProducerConfig);
    }

    @Override
    public <K, V> Producer<K, V> newProducer(KafkaProducerConfig<K, V> kafkaProducerConfig) {
        ObjectExtension.requireNonNull(kafkaProducerConfig, (String)"kafkaProducerConfig");
        return new ProducerProxy(this._configurationManager, this._metaManager, (KafkaProducerConfig)kafkaProducerConfig.clone());
    }

    @Override
    public void close() throws Exception {
        this._metaManager.close();
    }
}

