/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.kbear.client;

import java.util.Properties;
import org.apache.kafka.common.serialization.Deserializer;
import org.mydotey.java.ObjectExtension;
import org.mydotey.java.collection.PropertiesExtension;
import org.mydotey.kbear.client.ConsumerRestartListener;

public class KafkaConsumerConfig<K, V>
implements Cloneable {
    private Properties properties;
    private Deserializer<K> keyDeserializer;
    private Deserializer<V> valueDeserializer;
    private ConsumerRestartListener<K, V> consumerRestartListener;

    protected KafkaConsumerConfig() {
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Deserializer<K> getKeyDeserializer() {
        return this.keyDeserializer;
    }

    public Deserializer<V> getValueDeserializer() {
        return this.valueDeserializer;
    }

    public ConsumerRestartListener<K, V> getConsumerRestartListener() {
        return this.consumerRestartListener;
    }

    public KafkaConsumerConfig<K, V> clone() {
        try {
            KafkaConsumerConfig obj = (KafkaConsumerConfig)super.clone();
            obj.properties = PropertiesExtension.clone((Properties)this.properties);
            return obj;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "KafkaConsumerConfig [properties=" + this.properties + ", keyDeserializer=" + this.keyDeserializer + ", valueDeserializer=" + this.valueDeserializer + ", consumerRestartListener=" + this.consumerRestartListener + "]";
    }

    public static class Builder<K, V> {
        private KafkaConsumerConfig<K, V> config = new KafkaConsumerConfig();

        public Builder<K, V> setProperties(Properties properties) {
            ((KafkaConsumerConfig)this.config).properties = properties;
            return this;
        }

        public Builder<K, V> setKeyDeserializer(Deserializer<K> keyDeserializer) {
            ((KafkaConsumerConfig)this.config).keyDeserializer = keyDeserializer;
            return this;
        }

        public Builder<K, V> setValueDeserializer(Deserializer<V> valueDeserializer) {
            ((KafkaConsumerConfig)this.config).valueDeserializer = valueDeserializer;
            return this;
        }

        public Builder<K, V> setConsumerRestartListener(ConsumerRestartListener<K, V> consumerRestartListener) {
            ((KafkaConsumerConfig)this.config).consumerRestartListener = consumerRestartListener;
            return this;
        }

        public KafkaConsumerConfig<K, V> build() {
            ObjectExtension.requireNonNull((Object)((KafkaConsumerConfig)this.config).properties, (String)"properties");
            return this.config.clone();
        }
    }
}

