/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.kbear.client;

import java.util.Properties;
import org.apache.kafka.common.serialization.Serializer;
import org.mydotey.java.ObjectExtension;
import org.mydotey.java.collection.PropertiesExtension;

public class KafkaProducerConfig<K, V>
implements Cloneable {
    private Properties properties;
    private Serializer<K> keySerializer;
    private Serializer<V> valueSerializer;

    protected KafkaProducerConfig() {
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public KafkaProducerConfig<K, V> clone() {
        try {
            KafkaProducerConfig obj = (KafkaProducerConfig)super.clone();
            obj.properties = PropertiesExtension.clone((Properties)this.properties);
            return obj;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "KafkaProducerConfig [properties=" + this.properties + ", keySerializer=" + this.keySerializer + ", valueSerializer=" + this.valueSerializer + "]";
    }

    public static class Builder<K, V> {
        private KafkaProducerConfig<K, V> config = new KafkaProducerConfig();

        public Builder<K, V> setProperties(Properties properties) {
            ((KafkaProducerConfig)this.config).properties = properties;
            return this;
        }

        public Builder<K, V> setKeySerializer(Serializer<K> keySerializer) {
            ((KafkaProducerConfig)this.config).keySerializer = keySerializer;
            return this;
        }

        public Builder<K, V> setValueSerializer(Serializer<V> valueSerializer) {
            ((KafkaProducerConfig)this.config).valueSerializer = valueSerializer;
            return this;
        }

        public KafkaProducerConfig<K, V> build() {
            ObjectExtension.requireNonNull((Object)((KafkaProducerConfig)this.config).properties, (String)"properties");
            return this.config.clone();
        }
    }
}

