/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.kbear.meta;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mydotey.java.ObjectExtension;
import org.mydotey.kbear.meta.FetchClustersRequest;
import org.mydotey.kbear.meta.FetchClustersResponse;
import org.mydotey.kbear.meta.FetchConsumerGroupsRequest;
import org.mydotey.kbear.meta.FetchConsumerGroupsResponse;
import org.mydotey.kbear.meta.FetchTopicsRequest;
import org.mydotey.kbear.meta.FetchTopicsResponse;
import org.mydotey.kbear.meta.MetaService;
import org.mydotey.rpc.client.http.HttpServiceClient;
import org.mydotey.rpc.client.http.HttpServiceClientConfig;

public class MetaServiceClient
implements MetaService,
AutoCloseable {
    private static final String FETCH_CLUSTERS_PROCEDURE = "meta/fetchClusters";
    private static final String FETCH_TOPICS_PROCEDURE = "meta/fetchTopics";
    private static final String FETCH_CONSUMER_GROUPS_PROCEDURE = "meta/fetchConsumerGroups";
    public static final Map<String, String> PROCEDURE_REST_PATH_MAP;
    private HttpServiceClient _serviceClient;

    public MetaServiceClient(HttpServiceClientConfig config) {
        ObjectExtension.requireNonNull((Object)config, (String)"config");
        this._serviceClient = new HttpServiceClient(config);
    }

    public HttpServiceClientConfig getConfig() {
        return this._serviceClient.getConfig();
    }

    @Override
    public FetchClustersResponse fetchClusters(FetchClustersRequest request) {
        return (FetchClustersResponse)this._serviceClient.invoke(FETCH_CLUSTERS_PROCEDURE, (Object)request, FetchClustersResponse.class);
    }

    @Override
    public FetchTopicsResponse fetchTopics(FetchTopicsRequest request) {
        return (FetchTopicsResponse)this._serviceClient.invoke(FETCH_TOPICS_PROCEDURE, (Object)request, FetchTopicsResponse.class);
    }

    @Override
    public FetchConsumerGroupsResponse fetchConsumerGroups(FetchConsumerGroupsRequest request) {
        return (FetchConsumerGroupsResponse)this._serviceClient.invoke(FETCH_CONSUMER_GROUPS_PROCEDURE, (Object)request, FetchConsumerGroupsResponse.class);
    }

    @Override
    public void close() throws Exception {
        this._serviceClient.close();
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(FETCH_CLUSTERS_PROCEDURE, "/meta/clusters");
        map.put(FETCH_TOPICS_PROCEDURE, "/meta/topics");
        map.put(FETCH_CONSUMER_GROUPS_PROCEDURE, "/meta/consumer-groups");
        PROCEDURE_REST_PATH_MAP = Collections.unmodifiableMap(map);
    }
}

