/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.kbear.route;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mydotey.java.ObjectExtension;
import org.mydotey.kbear.route.FetchConsumerRouteRequest;
import org.mydotey.kbear.route.FetchConsumerRouteResponse;
import org.mydotey.kbear.route.FetchProducerRouteRequest;
import org.mydotey.kbear.route.FetchProducerRouteResponse;
import org.mydotey.kbear.route.FetchRouteRulesRequest;
import org.mydotey.kbear.route.FetchRouteRulesResponse;
import org.mydotey.kbear.route.RouteService;
import org.mydotey.rpc.client.http.HttpServiceClient;
import org.mydotey.rpc.client.http.HttpServiceClientConfig;

public class RouteServiceClient
implements RouteService,
AutoCloseable {
    private static final String FETCH_ROUTE_RULES_PROCEDURE = "route/fetchRouteRules";
    private static final String FETCH_PRODUCER_ROUTE_PROCEDURE = "route/fetchProducerRoute";
    private static final String FETCH_CONSUMER_ROUTE_PROCEDURE = "route/fetchConsumerRoute";
    public static final Map<String, String> PROCEDURE_REST_PATH_MAP;
    private HttpServiceClient _serviceClient;

    public RouteServiceClient(HttpServiceClientConfig config) {
        ObjectExtension.requireNonNull((Object)config, (String)"config");
        this._serviceClient = new HttpServiceClient(config);
    }

    public HttpServiceClientConfig getConfig() {
        return this._serviceClient.getConfig();
    }

    @Override
    public FetchRouteRulesResponse fetchRouteRules(FetchRouteRulesRequest request) {
        return (FetchRouteRulesResponse)this._serviceClient.invoke(FETCH_ROUTE_RULES_PROCEDURE, (Object)request, FetchRouteRulesResponse.class);
    }

    @Override
    public FetchProducerRouteResponse fetchProducerRoute(FetchProducerRouteRequest request) {
        return (FetchProducerRouteResponse)this._serviceClient.invoke(FETCH_PRODUCER_ROUTE_PROCEDURE, (Object)request, FetchProducerRouteResponse.class);
    }

    @Override
    public FetchConsumerRouteResponse fetchConsumerRoute(FetchConsumerRouteRequest request) {
        return (FetchConsumerRouteResponse)this._serviceClient.invoke(FETCH_CONSUMER_ROUTE_PROCEDURE, (Object)request, FetchConsumerRouteResponse.class);
    }

    @Override
    public void close() throws Exception {
        this._serviceClient.close();
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(FETCH_ROUTE_RULES_PROCEDURE, "/route/rules");
        map.put(FETCH_PRODUCER_ROUTE_PROCEDURE, "/route/producer");
        map.put(FETCH_CONSUMER_ROUTE_PROCEDURE, "/route/consumer");
        PROCEDURE_REST_PATH_MAP = Collections.unmodifiableMap(map);
    }
}

