/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class GenericArray<T>
implements Iterable<T> {
    private List<T> _data;
    private int _length;

    public GenericArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Array length cannot be less than 0.");
        }
        this._length = length;
        this._data = new ArrayList<T>(this._length);
        for (int index = 0; index < this._length; ++index) {
            this._data.add(null);
        }
    }

    public void set(int index, T element) {
        this.checkIndex(index);
        this._data.set(index, element);
    }

    public T get(int index) {
        this.checkIndex(index);
        return this._data.get(index);
    }

    public int length() {
        return this._length;
    }

    public T[] toArray(T[] a) {
        return this._data.toArray(a);
    }

    public List<T> toList() {
        return Collections.unmodifiableList(this._data);
    }

    public void clear() {
        for (int index = 0; index < this._length; ++index) {
            this._data.set(index, null);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this._data.iterator();
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this._length) {
            throw new IndexOutOfBoundsException();
        }
    }
}

