/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java;

import java.util.function.Supplier;
import org.mydotey.java.ObjectExtension;
import org.slf4j.LoggerFactory;

public interface LoopExtension {
    public static final int DEFAULT_SLEEP_NANOS_IN_TIGHT_LOOP = 1000;

    public static <V> V executeWithoutTightLoop(Supplier<V> func) throws InterruptedException {
        return LoopExtension.executeWithoutTightLoop(func, 0, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V executeWithoutTightLoop(Supplier<V> func, int ms, int nanos) throws InterruptedException {
        ObjectExtension.requireNonNull(func, "func");
        long startTime = System.currentTimeMillis();
        try {
            V v = func.get();
            return v;
        }
        finally {
            if (System.currentTimeMillis() - startTime <= 0L) {
                LoopExtension.preventTightLoop(ms, nanos);
            }
        }
    }

    public static void executeWithoutTightLoop(Runnable action) throws InterruptedException {
        LoopExtension.executeWithoutTightLoop(action, 0, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeWithoutTightLoop(Runnable action, int ms, int nanos) throws InterruptedException {
        ObjectExtension.requireNonNull(action, "action");
        long startTime = System.currentTimeMillis();
        try {
            action.run();
        }
        finally {
            if (System.currentTimeMillis() - startTime <= 0L) {
                LoopExtension.preventTightLoop(ms, nanos);
            }
        }
    }

    public static void preventTightLoop() throws InterruptedException {
        LoopExtension.preventTightLoop(0, 1000);
    }

    public static void preventTightLoop(int ms, int nanos) throws InterruptedException {
        LoggerFactory.getLogger(LoopExtension.class).info("Sleep {} ms & {} nanos to prevent tight loop.", (Object)ms, (Object)nanos);
        Thread.sleep(ms, nanos);
    }
}

