/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.mydotey.java.ObjectExtension;

public class MultiWriteBatchReadList<V> {
    private volatile AtomicInteger _index = new AtomicInteger();
    private volatile ConcurrentHashMap<Integer, V> _data;

    public MultiWriteBatchReadList() {
        this(0);
    }

    public MultiWriteBatchReadList(int initialCapacity) {
        this._data = new ConcurrentHashMap(initialCapacity);
    }

    public void add(V value) {
        ObjectExtension.requireNonNull(value, "value");
        this._data.put(this._index.getAndIncrement(), value);
    }

    public int size() {
        return this._index.get();
    }

    public List<V> getAll() {
        V item;
        ArrayList<V> values = new ArrayList<V>();
        for (int i = 0; i < this.size() && (item = this._data.get(i)) != null; ++i) {
            values.add(item);
        }
        return values;
    }
}

