/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java.io.file;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.mydotey.java.ObjectExtension;

public interface FileExtension {
    public static String readFileContent(Path file) throws IOException {
        return FileExtension.readFileContent(file, StandardCharsets.UTF_8);
    }

    public static String readFileContent(Path file, Charset charset) throws IOException {
        ObjectExtension.requireNonNull(file, "file");
        ObjectExtension.requireNonNull(charset, "charset");
        byte[] data = Files.readAllBytes(file);
        return new String(data, charset);
    }

    public static void writeFileContent(Path file, String content) throws IOException {
        FileExtension.writeFileContent(file, content, StandardCharsets.UTF_8);
    }

    public static void writeFileContent(Path file, String content, Charset charset) throws IOException {
        ObjectExtension.requireNonNull(file, "file");
        ObjectExtension.requireNonNull(charset, "charset");
        byte[] data = content == null ? new byte[]{} : content.getBytes(charset);
        Files.write(file, data, StandardOpenOption.CREATE);
    }
}

