package org.mydotey.java.collection;

import org.mydotey.java.StringExtension;

/**
 * Created by Qiang Zhao on 10/05/2016.
 */
public class KeyValuePair<K, V> {

    private K key;
    private V value;

    public KeyValuePair() {

    }

    public KeyValuePair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public V getValue() {
        return value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((key == null) ? 0 : key.hashCode());
        result = prime * result + ((value == null) ? 0 : value.hashCode());
        return result;
    }

    @SuppressWarnings("rawtypes")
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        KeyValuePair other = (KeyValuePair) obj;
        if (key == null) {
            if (other.key != null)
                return false;
        } else if (!key.equals(other.key))
            return false;
        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        return true;
    }

    @Override
    public String toString() {
        if (key == null && value == null)
            return null;

        return String.format("%s: %s", StringExtension.nullToEmpty(StringExtension.toString(key)),
                StringExtension.nullToEmpty(StringExtension.toString(value)));
    }

}
