/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java;

import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mydotey.java.GenericArray;

public class GenericArrayTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void length() {
        int length = 10;
        GenericArray stringArray = new GenericArray(length);
        Assert.assertEquals((long)length, (long)stringArray.length());
        length = 0;
        stringArray = new GenericArray(length);
        Assert.assertEquals((long)length, (long)stringArray.length());
    }

    @Test
    public void length2() {
        this.thrown.expect(IllegalArgumentException.class);
        int length = -1;
        new GenericArray(length);
    }

    @Test
    public void getSet() {
        int length = 10;
        HashMap<Integer, String> testData = new HashMap<Integer, String>();
        testData.put(0, "test");
        testData.put(5, "test5");
        testData.put(9, "test9");
        GenericArray stringArray = new GenericArray(length);
        testData.forEach((i, d) -> {
            stringArray.set(i.intValue(), d);
            Assert.assertEquals((Object)d, (Object)stringArray.get(i.intValue()));
        });
        Assert.assertNull((Object)stringArray.get(1));
    }

    @Test
    public void getSet2() {
        this.thrown.expect(IndexOutOfBoundsException.class);
        int length = 10;
        GenericArray stringArray = new GenericArray(length);
        stringArray.set(length, (Object)"test");
    }

    @Test
    public void getSet3() {
        this.thrown.expect(IndexOutOfBoundsException.class);
        int length = 10;
        GenericArray stringArray = new GenericArray(length);
        stringArray.set(-1, (Object)"test");
    }

    @Test
    public void getSet4() {
        this.thrown.expect(IndexOutOfBoundsException.class);
        int length = 10;
        GenericArray stringArray = new GenericArray(length);
        stringArray.get(length);
    }

    @Test
    public void getSet5() {
        this.thrown.expect(IndexOutOfBoundsException.class);
        int length = 10;
        GenericArray stringArray = new GenericArray(length);
        stringArray.get(-1);
    }

    @Test
    public void toArray() {
        int i2;
        int length = 2;
        HashMap<Integer, String> testData = new HashMap<Integer, String>();
        testData.put(0, "test");
        testData.put(1, "test1");
        GenericArray stringArray = new GenericArray(length);
        testData.forEach((i, d) -> stringArray.set(i.intValue(), d));
        Object[] stringArray2 = new String[stringArray.length()];
        String[] stringArray3 = (String[])stringArray.toArray(stringArray2);
        Assert.assertEquals((long)stringArray.length(), (long)stringArray2.length);
        Assert.assertSame((Object)stringArray2, (Object)stringArray3);
        for (i2 = 0; i2 < stringArray.length(); ++i2) {
            Assert.assertEquals((Object)stringArray.get(i2), (Object)stringArray2[i2]);
        }
        stringArray2 = new String[stringArray.length() - 1];
        stringArray3 = (String[])stringArray.toArray(stringArray2);
        Assert.assertNotEquals((long)stringArray.length(), (long)stringArray2.length);
        Assert.assertNotSame((Object)stringArray2, (Object)stringArray3);
        for (i2 = 0; i2 < stringArray.length(); ++i2) {
            Assert.assertEquals((Object)stringArray.get(i2), (Object)stringArray3[i2]);
        }
        stringArray2 = new String[stringArray.length() + 1];
        stringArray3 = (String[])stringArray.toArray(stringArray2);
        Assert.assertNotEquals((long)stringArray.length(), (long)stringArray2.length);
        Assert.assertSame((Object)stringArray2, (Object)stringArray3);
        for (i2 = 0; i2 < stringArray.length(); ++i2) {
            Assert.assertEquals((Object)stringArray.get(i2), (Object)stringArray2[i2]);
        }
        Assert.assertNull((Object)stringArray2[stringArray.length()]);
    }

    @Test
    public void toList() {
        int length = 2;
        HashMap<Integer, String> testData = new HashMap<Integer, String>();
        testData.put(0, "test");
        testData.put(1, "test1");
        GenericArray stringArray = new GenericArray(length);
        testData.forEach((i, d) -> stringArray.set(i.intValue(), d));
        List stringList = stringArray.toList();
        Assert.assertEquals((long)length, (long)stringList.size());
        for (int i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((Object)stringArray.get(i2), stringList.get(i2));
        }
        GenericArray stringArray2 = new GenericArray(0);
        stringList = stringArray2.toList();
        Assert.assertTrue((boolean)stringList.isEmpty());
    }

    @Test
    public void toList2() {
        this.thrown.expect(UnsupportedOperationException.class);
        int length = 2;
        HashMap<Integer, String> testData = new HashMap<Integer, String>();
        testData.put(0, "test");
        testData.put(1, "test1");
        GenericArray stringArray = new GenericArray(length);
        testData.forEach((i, d) -> stringArray.set(i.intValue(), d));
        List stringList = stringArray.toList();
        stringList.add("test2");
    }

    @Test
    public void toList3() {
        this.thrown.expect(UnsupportedOperationException.class);
        int length = 2;
        HashMap<Integer, String> testData = new HashMap<Integer, String>();
        testData.put(0, "test");
        testData.put(1, "test1");
        GenericArray stringArray = new GenericArray(length);
        testData.forEach((i, d) -> stringArray.set(i.intValue(), d));
        List stringList = stringArray.toList();
        stringList.remove(0);
    }

    @Test
    public void toList4() {
        this.thrown.expect(UnsupportedOperationException.class);
        int length = 2;
        HashMap<Integer, String> testData = new HashMap<Integer, String>();
        testData.put(0, "test");
        testData.put(1, "test1");
        GenericArray stringArray = new GenericArray(length);
        testData.forEach((i, d) -> stringArray.set(i.intValue(), d));
        List stringList = stringArray.toList();
        stringList.set(0, "test2");
    }

    @Test
    public void clear() {
        int length = 2;
        HashMap<Integer, String> testData = new HashMap<Integer, String>();
        testData.put(0, "test");
        testData.put(1, "test1");
        GenericArray stringArray = new GenericArray(length);
        testData.forEach((i, d) -> stringArray.set(i.intValue(), d));
        stringArray.clear();
        Assert.assertEquals((long)length, (long)stringArray.length());
        for (int i2 = 0; i2 < length; ++i2) {
            Assert.assertNull((Object)stringArray.get(i2));
        }
    }

    @Test
    public void iterable() {
        int length = 2;
        HashMap<Integer, String> testData = new HashMap<Integer, String>();
        testData.put(0, "test");
        testData.put(1, "test1");
        GenericArray stringArray = new GenericArray(length);
        testData.forEach((i, d) -> stringArray.set(i.intValue(), d));
        for (String d2 : stringArray) {
            System.out.println(d2);
        }
    }

    @Test
    public void equals() {
        int length = 2;
        HashMap<Integer, String> testData = new HashMap<Integer, String>();
        testData.put(0, "test");
        testData.put(1, "test1");
        GenericArray stringArray = new GenericArray(length);
        GenericArray stringArray2 = new GenericArray(length);
        Assert.assertNotSame((Object)stringArray, (Object)stringArray2);
        Assert.assertEquals((Object)stringArray, (Object)stringArray2);
        Assert.assertEquals((long)stringArray.hashCode(), (long)stringArray2.hashCode());
        testData.forEach((i, d) -> stringArray.set(i.intValue(), d));
        Assert.assertNotEquals((Object)stringArray, (Object)stringArray2);
        Assert.assertNotEquals((long)stringArray.hashCode(), (long)stringArray2.hashCode());
        testData.forEach((i, d) -> stringArray2.set(i.intValue(), d));
        Assert.assertEquals((Object)stringArray, (Object)stringArray2);
        Assert.assertEquals((long)stringArray.hashCode(), (long)stringArray2.hashCode());
    }

    @Test
    public void toStringTest() {
        int length = 2;
        HashMap<Integer, String> testData = new HashMap<Integer, String>();
        testData.put(0, "test");
        testData.put(1, "test1");
        GenericArray stringArray = new GenericArray(length);
        List stringList = stringArray.toList();
        String s = stringArray.toString();
        System.out.println(s);
        Assert.assertEquals((Object)stringList.toString(), (Object)s);
        testData.forEach((i, d) -> stringArray.set(i.intValue(), d));
        String s2 = stringArray.toString();
        System.out.println(s2);
        Assert.assertNotEquals((Object)s, (Object)s2);
        Assert.assertEquals((Object)stringList.toString(), (Object)s2);
    }
}

