/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mydotey.java.StringExtension;

public class StringExtensionTest {
    @Test
    public void NULL() {
        Assert.assertEquals((Object)"null", (Object)StringExtension.NULL);
    }

    @Test
    public void isEmpty() {
        Assert.assertTrue((boolean)StringExtension.isEmpty(null));
        Assert.assertTrue((boolean)StringExtension.isEmpty((String)""));
        Assert.assertFalse((boolean)StringExtension.isEmpty((String)" "));
    }

    @Test
    public void isBlank() {
        Assert.assertTrue((boolean)StringExtension.isBlank(null));
        Assert.assertTrue((boolean)StringExtension.isBlank((String)""));
        Assert.assertTrue((boolean)StringExtension.isBlank((String)" "));
        Assert.assertFalse((boolean)StringExtension.isBlank((String)"test"));
    }

    @Test
    public void nullToEmpty() {
        Assert.assertEquals((Object)"", (Object)StringExtension.nullToEmpty(null));
        Assert.assertEquals((Object)"", (Object)StringExtension.nullToEmpty((String)""));
        Assert.assertEquals((Object)"test", (Object)StringExtension.nullToEmpty((String)"test"));
    }

    @Test
    public void toStringTest() {
        Object data = null;
        Assert.assertEquals(data, (Object)StringExtension.toString(data));
        data = new Object();
        Assert.assertEquals((Object)data.toString(), (Object)StringExtension.toString((Object)data));
        data = "test";
        Assert.assertSame((Object)data.toString(), (Object)StringExtension.toString((Object)data));
    }

    @Test
    public void toLowerCase() {
        String data = null;
        Assert.assertEquals(data, (Object)StringExtension.toLowerCase(data));
        data = "";
        Assert.assertEquals((Object)data.toLowerCase(), (Object)StringExtension.toLowerCase((String)data));
        data = "ok";
        Assert.assertEquals((Object)data.toLowerCase(), (Object)StringExtension.toLowerCase((String)data));
        data = "oK";
        Assert.assertEquals((Object)data.toLowerCase(), (Object)StringExtension.toLowerCase((String)data));
    }

    @Test
    public void toUpperCase() {
        String data = null;
        Assert.assertEquals(data, (Object)StringExtension.toUpperCase(data));
        data = "";
        Assert.assertEquals((Object)data.toUpperCase(), (Object)StringExtension.toUpperCase((String)data));
        data = "OK";
        Assert.assertEquals((Object)data.toUpperCase(), (Object)StringExtension.toUpperCase((String)data));
        data = "oK";
        Assert.assertEquals((Object)data.toUpperCase(), (Object)StringExtension.toUpperCase((String)data));
    }

    @Test
    public void intern() {
        String data = null;
        Assert.assertEquals(data, (Object)StringExtension.intern(data));
        data = "";
        Assert.assertEquals((Object)data.intern(), (Object)StringExtension.intern((String)data));
        data = "oK";
        Assert.assertEquals((Object)data.intern(), (Object)StringExtension.intern((String)data));
    }

    @Test
    public void equalsIgnoreCase() {
        String data = null;
        String data2 = null;
        Assert.assertEquals((Object)true, (Object)StringExtension.equalsIgnoreCase(data, data2));
        data = null;
        data2 = "test";
        Assert.assertEquals((Object)false, (Object)StringExtension.equalsIgnoreCase(data, (String)data2));
        data = "test";
        data2 = null;
        Assert.assertEquals((Object)data.equalsIgnoreCase(data2), (Object)StringExtension.equalsIgnoreCase((String)data, (String)data2));
        data = "test";
        data2 = "test";
        Assert.assertEquals((Object)data.equals(data2), (Object)StringExtension.equalsIgnoreCase((String)data, (String)data2));
        data = "test";
        data2 = "test2";
        Assert.assertEquals((Object)data.equals(data2), (Object)StringExtension.equalsIgnoreCase((String)data, (String)data2));
    }

    @Test
    public void trim() {
        String data = null;
        char[] chars = new char[]{};
        String expected = data;
        String actual = StringExtension.trim(data, (char[])chars);
        Assert.assertEquals(expected, (Object)actual);
        data = "test";
        chars = new char[]{};
        expected = data;
        actual = StringExtension.trim((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'e'};
        expected = data;
        actual = StringExtension.trim((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'t'};
        expected = "es";
        actual = StringExtension.trim((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test2";
        chars = new char[]{'t'};
        expected = "est2";
        actual = StringExtension.trim((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "2test";
        chars = new char[]{'t'};
        expected = "2tes";
        actual = StringExtension.trim((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'e', 't'};
        expected = "s";
        actual = StringExtension.trim((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'t', 'e'};
        expected = "s";
        actual = StringExtension.trim((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'1', 't'};
        expected = "es";
        actual = StringExtension.trim((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'1', '2'};
        expected = "test";
        actual = StringExtension.trim((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'t', 'e', 's'};
        expected = "";
        actual = StringExtension.trim((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'t', 'e', 's', '1', '2'};
        expected = "";
        actual = StringExtension.trim((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void trimStart() {
        String data = null;
        char[] chars = new char[]{};
        String expected = data;
        String actual = StringExtension.trimStart(data, (char[])chars);
        Assert.assertEquals(expected, (Object)actual);
        data = "test";
        chars = new char[]{};
        expected = data;
        actual = StringExtension.trimStart((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'e'};
        expected = data;
        actual = StringExtension.trimStart((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'t'};
        expected = "est";
        actual = StringExtension.trimStart((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "2test";
        chars = new char[]{'t'};
        expected = "2test";
        actual = StringExtension.trimStart((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'e', 't'};
        expected = "st";
        actual = StringExtension.trimStart((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'1', 't'};
        expected = "est";
        actual = StringExtension.trimStart((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'1', '2'};
        expected = "test";
        actual = StringExtension.trimStart((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'t', 'e', 's'};
        expected = "";
        actual = StringExtension.trimStart((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'t', 'e', 's', '1', '2'};
        expected = "";
        actual = StringExtension.trimStart((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void trimEnd() {
        String data = null;
        char[] chars = new char[]{};
        String expected = data;
        String actual = StringExtension.trimEnd(data, (char[])chars);
        Assert.assertEquals(expected, (Object)actual);
        data = "test";
        chars = new char[]{};
        expected = data;
        actual = StringExtension.trimEnd((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'e'};
        expected = data;
        actual = StringExtension.trimEnd((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'t'};
        expected = "tes";
        actual = StringExtension.trimEnd((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test2";
        chars = new char[]{'t'};
        expected = data;
        actual = StringExtension.trimEnd((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'s', 't'};
        expected = "te";
        actual = StringExtension.trimEnd((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'1', 't'};
        expected = "tes";
        actual = StringExtension.trimEnd((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'1', '2'};
        expected = "test";
        actual = StringExtension.trimEnd((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'t', 'e', 's'};
        expected = "";
        actual = StringExtension.trimEnd((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        chars = new char[]{'t', 'e', 's', '1', '2'};
        expected = "";
        actual = StringExtension.trimEnd((String)data, (char[])chars);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void trimString() {
        String data = null;
        String s = "";
        String expected = data;
        String actual = StringExtension.trim(data, (String)s);
        Assert.assertEquals(expected, (Object)actual);
        data = "test";
        s = "";
        expected = data;
        actual = StringExtension.trim((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "e";
        expected = data;
        actual = StringExtension.trim((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "t";
        expected = "es";
        actual = StringExtension.trim((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test2";
        s = "t";
        expected = "est2";
        actual = StringExtension.trim((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "2test";
        s = "t";
        expected = "2tes";
        actual = StringExtension.trim((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "te";
        expected = "st";
        actual = StringExtension.trim((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "123";
        expected = "test";
        actual = StringExtension.trim((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "test";
        expected = "";
        actual = StringExtension.trim((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "testok";
        expected = data;
        actual = StringExtension.trim((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void trimStartString() {
        String data = null;
        String s = "";
        String expected = data;
        String actual = StringExtension.trimStart(data, (String)s);
        Assert.assertEquals(expected, (Object)actual);
        data = "test";
        s = "";
        expected = data;
        actual = StringExtension.trimStart((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "e";
        expected = data;
        actual = StringExtension.trimStart((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "t";
        expected = "est";
        actual = StringExtension.trimStart((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "2test";
        s = "t";
        expected = "2test";
        actual = StringExtension.trimStart((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "te";
        expected = "st";
        actual = StringExtension.trimStart((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "12";
        expected = "test";
        actual = StringExtension.trimStart((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "tes";
        expected = "t";
        actual = StringExtension.trimStart((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "test12";
        expected = data;
        actual = StringExtension.trimStart((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void trimEndString() {
        String data = null;
        String s = "";
        String expected = data;
        String actual = StringExtension.trimEnd(data, (String)s);
        Assert.assertEquals(expected, (Object)actual);
        data = "test";
        s = "";
        expected = data;
        actual = StringExtension.trimEnd((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "e";
        expected = data;
        actual = StringExtension.trimEnd((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "t";
        expected = "tes";
        actual = StringExtension.trimEnd((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test2";
        s = "t";
        expected = data;
        actual = StringExtension.trimEnd((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "st";
        expected = "te";
        actual = StringExtension.trimEnd((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "1t";
        expected = data;
        actual = StringExtension.trimEnd((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "12";
        expected = data;
        actual = StringExtension.trimEnd((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "est";
        expected = "t";
        actual = StringExtension.trimEnd((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        data = "test";
        s = "12est";
        expected = data;
        actual = StringExtension.trimEnd((String)data, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void join() {
        Object[] array = null;
        char c = '.';
        String expected = null;
        String actual = StringExtension.join(array, (char)c);
        Assert.assertEquals(expected, (Object)actual);
        array = new Integer[]{1};
        c = '.';
        expected = "1";
        actual = StringExtension.join((Object[])array, (char)c);
        Assert.assertEquals((Object)expected, (Object)actual);
        array = new Integer[]{1, 2, 3};
        c = '.';
        expected = "1.2.3";
        actual = StringExtension.join((Object[])array, (char)c);
        Assert.assertEquals((Object)expected, (Object)actual);
        array = null;
        String s = ".";
        expected = null;
        actual = StringExtension.join((Object[])array, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        array = new Integer[]{1};
        s = ".";
        expected = "1";
        actual = StringExtension.join((Object[])array, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        array = new Integer[]{1, 2, 3};
        s = ".";
        expected = "1.2.3";
        actual = StringExtension.join((Object[])array, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        array = new Integer[]{1, 2, 3};
        s = "";
        expected = "123";
        actual = StringExtension.join((Object[])array, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        array = new Integer[]{1, 2, 3};
        s = "..";
        expected = "1..2..3";
        actual = StringExtension.join((Object[])array, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void join2() {
        List<Integer> collection = null;
        char c = '.';
        String expected = null;
        String actual = StringExtension.join(collection, (char)c);
        Assert.assertEquals(expected, (Object)actual);
        collection = Arrays.asList(1);
        c = '.';
        expected = "1";
        actual = StringExtension.join(collection, (char)c);
        Assert.assertEquals((Object)expected, (Object)actual);
        collection = Arrays.asList(1, 2, 3);
        c = '.';
        expected = "1.2.3";
        actual = StringExtension.join(collection, (char)c);
        Assert.assertEquals((Object)expected, (Object)actual);
        collection = null;
        String s = ".";
        expected = null;
        actual = StringExtension.join(collection, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        collection = Arrays.asList(1);
        s = ".";
        expected = "1";
        actual = StringExtension.join(collection, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        collection = Arrays.asList(1, 2, 3);
        s = ".";
        expected = "1.2.3";
        actual = StringExtension.join(collection, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        collection = Arrays.asList(1, 2, 3);
        s = "";
        expected = "123";
        actual = StringExtension.join(collection, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
        collection = Arrays.asList(1, 2, 3);
        s = "..";
        expected = "1..2..3";
        actual = StringExtension.join(collection, (String)s);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

