/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mydotey.java.ObjectExtension;

public class ObjectExtensionTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void NULL() {
        Object obj = ObjectExtension.NULL();
        Assert.assertNull((Object)obj);
        Integer obj2 = (Integer)ObjectExtension.NULL();
        Assert.assertNull((Object)obj2);
        String obj3 = (String)ObjectExtension.NULL();
        Assert.assertNull((Object)obj3);
    }

    @Test
    public void requireNonNull() {
        Object obj = null;
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is null");
        ObjectExtension.requireNonNull(obj, (String)name);
    }

    @Test
    public void requireNonNull2() {
        Object obj = new Object();
        String name = "arg";
        ObjectExtension.requireNonNull((Object)obj, (String)name);
    }

    @Test
    public void requireNonEmpty() {
        String obj = null;
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }

    @Test
    public void requireNonEmpty2() {
        String obj = "";
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty((String)obj, (String)name);
    }

    @Test
    public void requireNonEmpty3() {
        String obj = "  ";
        String name = "arg";
        ObjectExtension.requireNonEmpty((String)obj, (String)name);
    }

    @Test
    public void requireNonBlank() {
        String obj = null;
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is blank");
        ObjectExtension.requireNonBlank(obj, (String)name);
    }

    @Test
    public void requireNonBlank2() {
        String obj = "";
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is blank");
        ObjectExtension.requireNonBlank((String)obj, (String)name);
    }

    @Test
    public void requireNonBlank3() {
        String obj = "  ";
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is blank");
        ObjectExtension.requireNonBlank((String)obj, (String)name);
    }

    @Test
    public void requireNonBlank4() {
        String obj = "test";
        String name = "arg";
        ObjectExtension.requireNonBlank((String)obj, (String)name);
    }

    @Test
    public void requireNonEmpty4() {
        Collection obj = null;
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }

    @Test
    public void requireNonEmpty5() {
        ArrayList obj = new ArrayList();
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }

    @Test
    public void requireNonEmpty6() {
        List<Object> obj = Arrays.asList(new Object());
        String name = "arg";
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }

    @Test
    public void requireNonEmpty7() {
        Object[] obj = null;
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }

    @Test
    public void requireNonEmpty8() {
        Object[] obj = new Object[]{};
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty((Object[])obj, (String)name);
    }

    @Test
    public void requireNonEmpty9() {
        Object[] obj = new Object[]{new Object()};
        String name = "arg";
        ObjectExtension.requireNonEmpty((Object[])obj, (String)name);
    }

    @Test
    public void requireNonEmpty10() {
        Map obj = null;
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }

    @Test
    public void requireNonEmpty11() {
        HashMap obj = new HashMap();
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }

    @Test
    public void requireNonEmpty12() {
        HashMap<String, String> obj = new HashMap<String, String>();
        obj.put("", "");
        String name = "arg";
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }
}

