/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.mydotey.java.ObjectScope;

public class ObjectScopeTest {
    @Test
    public void use() throws Exception {
        ObjectScope objectScope = new ObjectScope();
        Assert.assertNull((Object)objectScope.current());
        String obj = "test";
        try (ObjectScope.CloseableScope closeable = objectScope.use((Object)obj);){
            Assert.assertEquals((Object)obj, (Object)objectScope.current());
        }
        Assert.assertNull((Object)objectScope.current());
        String defaultValue = "default";
        objectScope = new ObjectScope((Object)defaultValue);
        Assert.assertEquals((Object)defaultValue, (Object)objectScope.current());
        try (ObjectScope.CloseableScope closeable = objectScope.use((Object)obj);){
            Assert.assertEquals((Object)obj, (Object)objectScope.current());
        }
        Assert.assertEquals((Object)defaultValue, (Object)objectScope.current());
    }

    @Test
    public void use2() throws InterruptedException {
        ObjectScope objectScope = new ObjectScope();
        int concurrency = 100;
        Thread[] threads = new Thread[concurrency];
        AtomicBoolean failed = new AtomicBoolean();
        CountDownLatch latch = new CountDownLatch(concurrency);
        for (int i = 0; i < concurrency; ++i) {
            int j = i;
            threads[j] = new Thread(() -> {
                System.out.printf("thread %s start\n", j);
                String current = (String)objectScope.current();
                if (current != null) {
                    failed.set(true);
                    System.out.printf("expected: %s, current: %s\n", null, current);
                }
                String obj = "test" + j;
                try (ObjectScope.CloseableScope closeable = objectScope.use((Object)obj);){
                    current = (String)objectScope.current();
                    if (!Objects.equals(obj, current)) {
                        failed.set(true);
                        System.out.printf("expected: %s, current: %s\n", obj, current);
                    }
                }
                catch (Exception e) {
                    failed.set(true);
                    e.printStackTrace();
                }
                current = (String)objectScope.current();
                if (current != null) {
                    failed.set(true);
                    System.out.printf("expected: %s, current: %s\n", null, current);
                }
                latch.countDown();
                System.out.printf("thread %s end\n", j);
            });
            threads[i].setDaemon(true);
        }
        Arrays.stream(threads).forEach(t -> t.start());
        latch.await(10L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)failed.get());
    }
}

