/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java.collection;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mydotey.java.collection.MultiWriteBatchReadList;

public class MultiWriteBatchReadListTest {
    @Test
    public void writeReadTest() {
        MultiWriteBatchReadList list = new MultiWriteBatchReadList();
        Assert.assertEquals((long)0L, (long)list.size());
        list.add((Object)"t1");
        Assert.assertEquals((long)1L, (long)list.size());
        list.add((Object)"t2");
        Assert.assertEquals((long)2L, (long)list.size());
        List all = list.getAll();
        Assert.assertEquals((long)2L, (long)all.size());
        Assert.assertEquals((Object)"t1", all.get(0));
        Assert.assertEquals((Object)"t2", all.get(1));
        list = new MultiWriteBatchReadList(10);
        Assert.assertEquals((long)0L, (long)list.size());
        all = list.getAll();
        Assert.assertEquals((long)0L, (long)all.size());
    }

    @Test
    public void writeReadTest2() throws InterruptedException {
        MultiWriteBatchReadList list = new MultiWriteBatchReadList();
        int concurrency = 100;
        int count = 100;
        Thread[] threads = new Thread[concurrency];
        CountDownLatch latch = new CountDownLatch(concurrency);
        int i = 0;
        while (i < concurrency) {
            int j = i++;
            threads[j] = new Thread(() -> {
                System.out.printf("thread %s start\n", j);
                for (int k = 0; k < count; ++k) {
                    list.add((Object)(String.valueOf(j) + String.valueOf(k)));
                }
                latch.countDown();
                System.out.printf("thread %s end\n", j);
            });
            threads[j].setDaemon(true);
        }
        Arrays.stream(threads).forEach(t -> t.start());
        latch.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((long)(concurrency * count), (long)list.size());
    }
}

