/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java.io.file;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Test;
import org.mydotey.java.io.file.FileExtension;

public class FileExtensionTest {
    @Test
    public void readFileContent() throws URISyntaxException, IOException {
        Path path = Paths.get(FileExtensionTest.class.getResource("test.txt").toURI());
        String expected = "1-1\n2-2";
        String actual = FileExtension.readFileContent((Path)path);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void writeFileContent() throws URISyntaxException, IOException {
        Path path = Paths.get("temp.txt", new String[0]);
        String expected = "1-1\n2-2\n3-3";
        FileExtension.writeFileContent((Path)path, (String)expected);
        String actual = FileExtension.readFileContent((Path)path);
        Assert.assertEquals((Object)expected, (Object)actual);
        Files.delete(path);
    }
}

