/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mydotey.java.ObjectExtension;

public class ObjectExtensionTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void NULL() {
        Object obj = ObjectExtension.NULL();
        Assert.assertNull((Object)obj);
        Integer obj2 = (Integer)ObjectExtension.NULL();
        Assert.assertNull((Object)obj2);
        String obj3 = (String)ObjectExtension.NULL();
        Assert.assertNull((Object)obj3);
    }

    @Test
    public void requireNonNull() {
        Object obj = null;
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is null");
        ObjectExtension.requireNonNull(obj, (String)name);
    }

    @Test
    public void requireNonNull2() {
        Object obj = new Object();
        String name = "arg";
        ObjectExtension.requireNonNull((Object)obj, (String)name);
    }

    @Test
    public void requireNonEmpty() {
        String obj = null;
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }

    @Test
    public void requireNonEmpty2() {
        String obj = "";
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty((String)obj, (String)name);
    }

    @Test
    public void requireNonEmpty3() {
        String obj = "  ";
        String name = "arg";
        ObjectExtension.requireNonEmpty((String)obj, (String)name);
    }

    @Test
    public void requireNonBlank() {
        String obj = null;
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is blank");
        ObjectExtension.requireNonBlank(obj, (String)name);
    }

    @Test
    public void requireNonBlank2() {
        String obj = "";
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is blank");
        ObjectExtension.requireNonBlank((String)obj, (String)name);
    }

    @Test
    public void requireNonBlank3() {
        String obj = "  ";
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is blank");
        ObjectExtension.requireNonBlank((String)obj, (String)name);
    }

    @Test
    public void requireNonBlank4() {
        String obj = "test";
        String name = "arg";
        ObjectExtension.requireNonBlank((String)obj, (String)name);
    }

    @Test
    public void requireNonEmpty4() {
        Collection obj = null;
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }

    @Test
    public void requireNonEmpty5() {
        ArrayList obj = new ArrayList();
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }

    @Test
    public void requireNonEmpty6() {
        List<Object> obj = Arrays.asList(new Object());
        String name = "arg";
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }

    @Test
    public void requireNonEmpty7() {
        Object[] obj = null;
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }

    @Test
    public void requireNonEmpty8() {
        Object[] obj = new Object[]{};
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty((Object[])obj, (String)name);
    }

    @Test
    public void requireNonEmpty9() {
        Object[] obj = new Object[]{new Object()};
        String name = "arg";
        ObjectExtension.requireNonEmpty((Object[])obj, (String)name);
    }

    @Test
    public void requireNonEmpty10() {
        Map obj = null;
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }

    @Test
    public void requireNonEmpty11() {
        HashMap obj = new HashMap();
        String name = "arg";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is empty");
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }

    @Test
    public void requireNonEmpty12() {
        HashMap<String, String> obj = new HashMap<String, String>();
        obj.put("", "");
        String name = "arg";
        ObjectExtension.requireNonEmpty(obj, (String)name);
    }

    @Test
    public void requireNonNullOrEmpty() {
        Object obj = new Object();
        String name = "arg";
        ObjectExtension.requireNonNullOrEmpty((Object)obj, (String)name);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is null or empty");
        obj = null;
        ObjectExtension.requireNonNullOrEmpty((Object)obj, (String)name);
    }

    @Test
    public void requireNonNullOrEmpty2() {
        String obj = "test";
        String name = "arg";
        ObjectExtension.requireNonNullOrEmpty((Object)obj, (String)name);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is null or empty");
        obj = "  ";
        ObjectExtension.requireNonNullOrEmpty((Object)obj, (String)name);
    }

    @Test
    public void requireNonNullOrEmpty3() {
        List<Integer> obj = Arrays.asList(1, 2);
        String name = "arg";
        ObjectExtension.requireNonNullOrEmpty(obj, (String)name);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is null or empty");
        obj = new ArrayList<Integer>();
        ObjectExtension.requireNonNullOrEmpty(obj, (String)name);
    }

    @Test
    public void requireNonNullOrEmpty4() {
        Map<String, String> obj = Collections.singletonMap("k", "v");
        String name = "arg";
        ObjectExtension.requireNonNullOrEmpty(obj, (String)name);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is null or empty");
        obj = new HashMap<String, String>();
        ObjectExtension.requireNonNullOrEmpty(obj, (String)name);
    }

    @Test
    public void requireNonNullOrEmpty5() {
        Object[] obj = new Object[]{1, 2};
        String name = "arg";
        ObjectExtension.requireNonNullOrEmpty((Object)obj, (String)name);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(name + " is null or empty");
        obj = new Object[]{};
        ObjectExtension.requireNonNullOrEmpty((Object)obj, (String)name);
    }

    @Test
    public void requireNonNullOrEmpty6() {
        String name = "arg";
        ObjectExtension.requireNonNullOrEmpty((Object)0, (String)name);
        ObjectExtension.requireNonNullOrEmpty((Object)0.0, (String)name);
        ObjectExtension.requireNonNullOrEmpty((Object)false, (String)name);
        ObjectExtension.requireNonNullOrEmpty((Object)1, (String)name);
        ObjectExtension.requireNonNullOrEmpty((Object)new Object(), (String)name);
    }

    @Test
    public void isNullOrEmpty() {
        Assert.assertTrue((boolean)ObjectExtension.isNullOrEmpty(null));
        Assert.assertTrue((boolean)ObjectExtension.isNullOrEmpty((Object)""));
        Assert.assertTrue((boolean)ObjectExtension.isNullOrEmpty((Object)"  "));
        Assert.assertTrue((boolean)ObjectExtension.isNullOrEmpty(new ArrayList()));
        Assert.assertTrue((boolean)ObjectExtension.isNullOrEmpty(new HashMap()));
        Assert.assertTrue((boolean)ObjectExtension.isNullOrEmpty((Object)new Object[0]));
        Assert.assertFalse((boolean)ObjectExtension.isNullOrEmpty((Object)0));
        Assert.assertFalse((boolean)ObjectExtension.isNullOrEmpty((Object)0.0));
        Assert.assertFalse((boolean)ObjectExtension.isNullOrEmpty((Object)false));
        Assert.assertFalse((boolean)ObjectExtension.isNullOrEmpty((Object)new Object()));
    }
}

