/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java.function;

import java.util.Comparator;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mydotey.java.function.SingletonSupplier;

public class SingletonSupplierTest {
    private int _concurrency = 50;
    private int _completeTime = 100;
    private static Comparator<Object> _objectComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            return o1.hashCode() > o2.hashCode() ? 1 : -1;
        }
    };
    @Rule
    public final ExpectedException expectedExceptionRule = ExpectedException.none();

    @Test
    public void test() {
        this.expectedExceptionRule.expect(IllegalStateException.class);
        SingletonSupplier supplier = new SingletonSupplier(() -> null);
        supplier.get();
    }

    @Test
    public void test2() {
        Object obj = new Object();
        this.test(() -> obj);
        this.test(() -> new Object());
    }

    private void test(Supplier<Object> getter) {
        getter = new SingletonSupplier(getter);
        boolean isSingleton = this.isSingletonGet((Supplier<Object>)getter);
        Assert.assertTrue((boolean)isSingleton);
    }

    private boolean isSingletonGet(final Supplier<Object> getter) {
        final ConcurrentSkipListSet<Object> set = new ConcurrentSkipListSet<Object>(_objectComparator);
        final AtomicBoolean canStart = new AtomicBoolean();
        final AtomicInteger completed = new AtomicInteger();
        for (int i = 0; i < this._concurrency; ++i) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        if (canStart.get()) break;
                        Thread.yield();
                    }
                    set.add(getter.get());
                    completed.incrementAndGet();
                }
            });
            thread.setDaemon(true);
            thread.start();
        }
        canStart.set(true);
        try {
            Thread.sleep(this._completeTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return completed.get() == this._concurrency && set.size() == 1;
    }
}

