/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java;

import java.util.Arrays;
import java.util.Collection;
import org.mydotey.java.collection.CollectionExtension;

public interface StringExtension {
    public static final String EMPTY = "";
    public static final String NULL = String.valueOf(null);

    public static boolean isEmpty(String obj) {
        return obj == null || obj.isEmpty();
    }

    public static boolean isBlank(String obj) {
        if (StringExtension.isEmpty(obj)) {
            return true;
        }
        for (int i = 0; i < obj.length(); ++i) {
            if (Character.isWhitespace(obj.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String nullToEmpty(String obj) {
        return obj == null ? EMPTY : obj;
    }

    public static String toString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static String toLowerCase(String value) {
        if (value == null) {
            return null;
        }
        return value.toLowerCase();
    }

    public static String toUpperCase(String value) {
        if (value == null) {
            return null;
        }
        return value.toUpperCase();
    }

    public static String intern(String value) {
        return value == null ? null : value.intern();
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static String trim(String s, char ... chars) {
        s = StringExtension.trimStart(s, chars);
        s = StringExtension.trimEnd(s, chars);
        return s;
    }

    public static String trimEnd(String s, char ... chars) {
        int i;
        char c;
        int index;
        if (s == null || chars == null) {
            return s;
        }
        Arrays.sort(chars);
        for (index = s.length() - 1; index >= 0 && (Character.isWhitespace(c = s.charAt(index)) || (i = Arrays.binarySearch(chars, c)) >= 0); --index) {
        }
        if (index == s.length() - 1) {
            return s;
        }
        return index < 0 ? EMPTY : s.substring(0, index + 1);
    }

    public static String trimStart(String s, char ... chars) {
        int i;
        char c;
        int index;
        if (s == null || chars == null) {
            return s;
        }
        Arrays.sort(chars);
        for (index = 0; index < s.length() && (Character.isWhitespace(c = s.charAt(index)) || (i = Arrays.binarySearch(chars, c)) >= 0); ++index) {
        }
        if (index == 0) {
            return s;
        }
        return index == s.length() ? EMPTY : s.substring(index);
    }

    public static String trim(String s, String s2) {
        s = StringExtension.trimStart(s, s2);
        s = StringExtension.trimEnd(s, s2);
        return s;
    }

    public static String trimStart(String s, String s2) {
        if (s == null || s2 == null) {
            return s;
        }
        if (StringExtension.isEmpty(s2 = StringExtension.trim(s2, new char[0]))) {
            return StringExtension.trim(s, new char[0]);
        }
        if (StringExtension.isBlank(s = StringExtension.trim(s, new char[0]))) {
            return s;
        }
        if (s2.length() > s.length()) {
            return s;
        }
        if (!s.startsWith(s2)) {
            return s;
        }
        if (s.length() == s2.length()) {
            return EMPTY;
        }
        s = s.substring(s2.length());
        return StringExtension.trimStart(s, s2);
    }

    public static String trimEnd(String s, String s2) {
        if (s == null || s2 == null) {
            return s;
        }
        if (StringExtension.isEmpty(s2 = StringExtension.trim(s2, new char[0]))) {
            return StringExtension.trim(s, new char[0]);
        }
        if (StringExtension.isEmpty(s = StringExtension.trim(s, new char[0]))) {
            return s;
        }
        if (s2.length() > s.length()) {
            return s;
        }
        if (!s.endsWith(s2)) {
            return s;
        }
        if (s.length() == s2.length()) {
            return EMPTY;
        }
        s = s.substring(0, s.length() - s2.length());
        return StringExtension.trimEnd(s, s2);
    }

    public static <T> String join(T[] data, char separator) {
        return StringExtension.join(data, String.valueOf(separator));
    }

    public static <T> String join(T[] data, String separator) {
        if (CollectionExtension.isEmpty(data)) {
            return null;
        }
        return StringExtension.join(Arrays.asList(data), separator);
    }

    public static String join(Collection<?> data, char separator) {
        return StringExtension.join(data, String.valueOf(separator));
    }

    public static String join(Collection<?> data, String separator) {
        if (CollectionExtension.isEmpty(data)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : data) {
            if (item == null) continue;
            sb.append(item);
            if (separator == null) continue;
            sb.append(separator);
        }
        if (sb.length() == 0) {
            return null;
        }
        if (separator == null) {
            return sb.toString();
        }
        return sb.substring(0, sb.length() - separator.length());
    }
}

