/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java.collection;

import org.mydotey.java.StringExtension;

public class KeyValuePair<K, V> {
    private K key;
    private V value;

    public KeyValuePair() {
    }

    public KeyValuePair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyValuePair other = (KeyValuePair)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        if (this.key == null && this.value == null) {
            return null;
        }
        return String.format("%s: %s", StringExtension.nullToEmpty(StringExtension.toString(this.key)), StringExtension.nullToEmpty(StringExtension.toString(this.value)));
    }

    public static KeyValuePair<String, String> parse(String s) {
        return KeyValuePair.parse(s, ":");
    }

    public static KeyValuePair<String, String> parse(String s, String separator) {
        if (StringExtension.isBlank(s) || StringExtension.isBlank(separator)) {
            return null;
        }
        String[] parts = (s = s.trim()).split(separator = separator.trim(), 2);
        if (parts.length != 2) {
            return null;
        }
        if (StringExtension.isBlank(parts[0]) || StringExtension.isBlank(parts[1])) {
            return null;
        }
        return new KeyValuePair<String, String>(parts[0].trim(), parts[1].trim());
    }
}

