/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.mydotey.java.InterruptedRuntimeException;
import org.mydotey.java.ThreadExtension;

public class ThreadExtensionTest {
    @Test
    public void sleep() {
        long before = System.nanoTime();
        ThreadExtension.sleep((int)10);
        long after = System.nanoTime();
        long elipsed = after - before;
        System.out.println("elipsed: " + elipsed);
        Assert.assertTrue((elipsed >= 10000000L ? 1 : 0) != 0);
        before = System.nanoTime();
        ThreadExtension.sleep((int)0, (int)1000);
        after = System.nanoTime();
        elipsed = after - before;
        System.out.println("elipsed: " + elipsed);
        Assert.assertTrue((elipsed >= 1000L ? 1 : 0) != 0);
        before = System.nanoTime();
        ThreadExtension.sleep((int)10, (int)1000);
        after = System.nanoTime();
        elipsed = after - before;
        System.out.println("elipsed: " + elipsed);
        Assert.assertTrue((elipsed >= 10001000L ? 1 : 0) != 0);
    }

    @Test
    public void sleep2() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicBoolean interupted = new AtomicBoolean();
        Thread thread = new Thread(() -> {
            System.out.println("sleep start");
            try {
                ThreadExtension.sleep((int)100);
            }
            catch (InterruptedRuntimeException ex) {
                interupted.set(true);
            }
            latch.countDown();
            System.out.println("sleep end");
        });
        thread.setDaemon(true);
        Assert.assertEquals((Object)((Object)Thread.State.NEW), (Object)((Object)thread.getState()));
        thread.start();
        Thread.sleep(10L);
        Assert.assertEquals((Object)((Object)Thread.State.TIMED_WAITING), (Object)((Object)thread.getState()));
        Assert.assertFalse((boolean)interupted.get());
        thread.interrupt();
        latch.await(1L, TimeUnit.SECONDS);
        Thread.sleep(10L);
        Assert.assertEquals((Object)((Object)Thread.State.TERMINATED), (Object)((Object)thread.getState()));
        Assert.assertTrue((boolean)interupted.get());
    }
}

