/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.tool.kafka;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignmentStatus;
import kafka.utils.Json;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.mydotey.scala.converter.ScalaConverters;
import org.mydotey.tool.kafka.Clients;
import scala.Option;
import scala.Tuple2;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;

public class Assignments {
    public static final long DEFAULT_REASSIGN_THROTTLE_LIMIT = -1L;
    public static final long DEFAULT_REASSIGN_TIMEOUT = 10000L;
    private Clients _clients;

    public Assignments(Clients clients) {
        this._clients = clients;
    }

    public java.util.Map<String, java.util.Map<Integer, List<Integer>>> getOfTopics(Set<String> topics) {
        scala.collection.mutable.Set scTopics = (scala.collection.mutable.Set)JavaConverters.asScalaSetConverter(topics).asScala();
        scala.collection.immutable.Map scAssignmentsMap = this._clients.getKafkaZkClient().getPartitionAssignmentForTopics(scTopics.toSet());
        HashMap<String, java.util.Map<Integer, List<Integer>>> assignmentMap = new HashMap<String, java.util.Map<Integer, List<Integer>>>();
        ((java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)scAssignmentsMap).asJava()).forEach((t, m) -> {
            java.util.Map topicAssignments = assignmentMap.computeIfAbsent((String)t, k -> new HashMap());
            ((java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)m).asJava()).forEach((p, a) -> {
                List replicas = topicAssignments.computeIfAbsent((Integer)p, k -> new ArrayList());
                ((List)JavaConverters.seqAsJavaListConverter((Seq)a).asJava()).forEach(r -> replicas.add((Integer)r));
            });
        });
        return assignmentMap;
    }

    public void reassign(java.util.Map<String, java.util.Map<Integer, List<Integer>>> assignments) {
        this.reassign(assignments, -1L, -1L, 10000L);
    }

    public void reassign(java.util.Map<String, java.util.Map<Integer, List<Integer>>> assignments, long interBrokerLimit, long replicaAlterLogDirsLimit, long timeout) {
        String jsonString = this.toJson(assignments);
        ReassignPartitionsCommand.Throttle throttle = new ReassignPartitionsCommand.Throttle(interBrokerLimit, replicaAlterLogDirsLimit, ScalaConverters.to(() -> BoxedUnit.UNIT));
        ReassignPartitionsCommand.executeAssignment((KafkaZkClient)this._clients.getKafkaZkClient(), (Option)Option.apply((Object)this._clients.getAdminClient()), (String)jsonString, (ReassignPartitionsCommand.Throttle)throttle, (long)timeout);
    }

    public java.util.Map<String, java.util.Map<Integer, Status>> verifyAssignment(java.util.Map<String, java.util.Map<Integer, List<Integer>>> assignments) {
        HashMap<TopicPartition, List> assignments2 = new HashMap<TopicPartition, List>();
        assignments.forEach((t, a) -> a.forEach((p, bl) -> assignments2.put(new TopicPartition(t, p.intValue()), (List)bl)));
        scala.collection.mutable.HashMap partitionsToBeReassigned = new scala.collection.mutable.HashMap();
        assignments2.forEach((arg_0, arg_1) -> Assignments.lambda$verifyAssignment$8((scala.collection.mutable.Map)partitionsToBeReassigned, arg_0, arg_1));
        Map partitionsBeingReassigned = this._clients.getKafkaZkClient().getPartitionReassignment();
        HashMap<String, java.util.Map<Integer, Status>> result = new HashMap<String, java.util.Map<Integer, Status>>();
        assignments2.keySet().forEach(arg_0 -> this.lambda$verifyAssignment$10((scala.collection.mutable.Map)partitionsToBeReassigned, partitionsBeingReassigned, result, arg_0));
        return result;
    }

    public String toJson(java.util.Map<String, java.util.Map<Integer, List<Integer>>> assignments) {
        HashMap<String, Serializable> jsonMap = new HashMap<String, Serializable>();
        jsonMap.put("version", Integer.valueOf(1));
        ArrayList partitions = new ArrayList();
        jsonMap.put("partitions", partitions);
        assignments.forEach((t, a) -> a.forEach((p, bl) -> {
            HashMap<String, Object> partition = new HashMap<String, Object>();
            partitions.add(partition);
            partition.put("topic", t);
            partition.put("partition", p);
            partition.put("replicas", bl);
        }));
        return Json.encodeAsString(jsonMap);
    }

    public java.util.Map<String, java.util.Map<Integer, List<Integer>>> fromJson(String json) {
        HashMap<String, java.util.Map<Integer, List<Integer>>> assignments = new HashMap<String, java.util.Map<Integer, List<Integer>>>();
        Tuple2 parsed = ReassignPartitionsCommand.parsePartitionReassignmentData((String)json);
        ((List)JavaConverters.seqAsJavaListConverter((Seq)((Seq)parsed._1())).asJava()).forEach(t -> {
            java.util.Map topicAssignments = assignments.computeIfAbsent(((TopicPartition)t._1()).topic(), k -> new HashMap());
            topicAssignments.put(((TopicPartition)t._1()).partition(), (List)JavaConverters.seqAsJavaListConverter((Seq)((Seq)t._2())).asJava());
        });
        return assignments;
    }

    private /* synthetic */ void lambda$verifyAssignment$10(scala.collection.mutable.Map partitionsToBeReassigned, Map partitionsBeingReassigned, java.util.Map result, TopicPartition tp) {
        ReassignmentStatus status = ReassignPartitionsCommand.checkIfPartitionReassignmentSucceeded((KafkaZkClient)this._clients.getKafkaZkClient(), (TopicPartition)tp, (Map)partitionsToBeReassigned, (Map)partitionsBeingReassigned);
        java.util.Map topicStatus = result.computeIfAbsent(tp.topic(), k -> new HashMap());
        topicStatus.put(tp.partition(), Status.valueOf(status));
    }

    private static /* synthetic */ void lambda$verifyAssignment$8(scala.collection.mutable.Map partitionsToBeReassigned, TopicPartition tp, List bl) {
        partitionsToBeReassigned.put((Object)tp, (Object)((Buffer)JavaConverters.asScalaBufferConverter((List)bl).asScala()).seq());
    }

    public static enum Status {
        Completed,
        Failed,
        InProgress;


        public static Status valueOf(ReassignmentStatus kaStatus) {
            switch (kaStatus.status()) {
                case -1: {
                    return Failed;
                }
                case 0: {
                    return InProgress;
                }
                case 1: {
                    return Completed;
                }
            }
            throw new IllegalArgumentException("unknown status: " + kaStatus.status());
        }
    }
}

