/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.tool.kafka;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mydotey.tool.kafka.Assignments;
import org.mydotey.tool.kafka.Clients;
import org.mydotey.tool.kafka.Topics;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class Brokers {
    private Clients _clients;

    public Brokers(Clients clients) {
        this._clients = clients;
    }

    public Set<Integer> getAll() {
        Seq brokers = this._clients.getKafkaZkClient().getAllBrokersInCluster();
        List jBrokers = (List)JavaConverters.seqAsJavaListConverter((Seq)brokers).asJava();
        return jBrokers.stream().map(b -> b.id()).collect(Collectors.toSet());
    }

    public Set<String> getTopics(int broker) {
        Set<String> topics = new Topics(this._clients).getAll();
        return this.getAssignments(broker, topics).keySet();
    }

    public Map<String, Set<Integer>> getTopicPartitons(int broker, Set<String> topics) {
        HashMap<String, Set<Integer>> result = new HashMap<String, Set<Integer>>();
        this.getAssignments(broker, topics).forEach((t, a) -> result.put((String)t, a.keySet()));
        return result;
    }

    public Map<String, Map<Integer, List<Integer>>> getAssignments(int broker, Set<String> topics) {
        Map<String, Map<Integer, List<Integer>>> assignments = new Assignments(this._clients).getOfTopics(topics);
        HashMap<String, Map<Integer, List<Integer>>> results = new HashMap<String, Map<Integer, List<Integer>>>();
        assignments.forEach((t, a) -> a.forEach((p, bl) -> {
            if (bl.contains(broker)) {
                Map topicAssignments = results.computeIfAbsent((String)t, k -> new HashMap());
                topicAssignments.put(p, bl);
            }
        }));
        return results;
    }

    public Map<String, Map<Integer, List<Integer>>> getAssignments(int broker, String topic, Set<Integer> partitions) {
        Map<String, Map<Integer, List<Integer>>> assignments = new Assignments(this._clients).getOfTopics((Set<String>)ImmutableSet.of((Object)topic));
        HashMap<String, Map<Integer, List<Integer>>> results = new HashMap<String, Map<Integer, List<Integer>>>();
        assignments.forEach((t, a) -> a.forEach((p, bl) -> {
            if (bl.contains(broker) && partitions.contains(p)) {
                Map topicAssignments = results.computeIfAbsent((String)t, k -> new HashMap());
                topicAssignments.put(p, bl);
            }
        }));
        return results;
    }

    public Map<String, Map<Integer, List<Integer>>> generateAssignmentsForTransfer(int from, int to, Set<String> topics) {
        Map<String, Map<Integer, List<Integer>>> assignments = this.getAssignments(from, topics);
        this.changeAssignmentsForTransfer(from, to, assignments);
        return assignments;
    }

    public Map<String, Map<Integer, List<Integer>>> generateAssignmentsForTransfer(int from, int to, String topic, Set<Integer> partitions) {
        Map<String, Map<Integer, List<Integer>>> assignments = this.getAssignments(from, topic, partitions);
        this.changeAssignmentsForTransfer(from, to, assignments);
        return assignments;
    }

    protected void changeAssignmentsForTransfer(int from, int to, Map<String, Map<Integer, List<Integer>>> assignments) {
        assignments.forEach((t, a) -> a.forEach((p, bl) -> {
            if (bl.contains(to)) {
                String errorMessage = String.format("to (broker: %s) has been in the assignment list for partition: {%s, %s}", to, t, p);
                throw new IllegalArgumentException(errorMessage);
            }
            bl.replaceAll(b -> b == from ? to : b);
        }));
    }
}

