/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.tool.kafka;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kafka.common.KafkaException;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicListing;
import org.mydotey.tool.kafka.Clients;

public class Topics {
    public static final String CONSUMER_OFFSETS = "__consumer_offsets";
    private Clients _clients;

    public Topics(Clients clients) {
        this._clients = clients;
    }

    public Set<String> getAll() {
        return this.getAll(tl -> true);
    }

    public Set<String> getAllWithoutInternal() {
        return this.getAll(tl -> !tl.isInternal());
    }

    public Set<String> getAllInternal() {
        return this.getAll(tl -> tl.isInternal());
    }

    private Set<String> getAll(Predicate<TopicListing> filter) {
        ListTopicsOptions options = new ListTopicsOptions();
        options.listInternal(true);
        ListTopicsResult result = this._clients.getAdminClient().listTopics(options);
        try {
            return ((Collection)result.listings().get()).stream().filter(filter).map(tl -> tl.name()).collect(Collectors.toSet());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new KafkaException((Throwable)e);
        }
    }
}

