/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.statistics.generator.formats;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import org.n52.iceland.statistics.api.parameters.AbstractEsParameter;
import org.n52.iceland.statistics.api.parameters.Description;
import org.n52.iceland.statistics.api.parameters.ObjectEsParameter;
import org.n52.iceland.statistics.api.parameters.SingleEsParameter;

public class MdFormat {
    private static final String LINE_TEMPLATE = " - **<fieldname>** - <desc>.";
    private static final String TYPE_TEMPLATE = " Type: <type>";
    private static final String NEW_LINE = "\n";
    private static final String NO_DESCRIPTION = "No available description";
    private static final String TAB = "\t";
    private static final String DESCRIPTION_PLACEHOLDER = "<desc>";
    private Map<Description.Operation, Map<Description.InformationOrigin, List<AbstractEsParameter>>> parameters;
    private StringBuilder output;

    private String formatLine(AbstractEsParameter parameter, int indent) {
        String line = Strings.repeat((String)TAB, (int)indent);
        line = line + LINE_TEMPLATE.replace("<fieldname>", parameter.getName());
        if (parameter.getDescription() != null) {
            line = parameter.getDescription().getDesc() != null ? line.replace(DESCRIPTION_PLACEHOLDER, parameter.getDescription().getDesc()) : line.replace(DESCRIPTION_PLACEHOLDER, NO_DESCRIPTION);
            if (parameter.getType() != null) {
                line = line + TYPE_TEMPLATE.replace("<type>", parameter.getType().humanReadableType());
            }
        } else {
            line = line.replace(DESCRIPTION_PLACEHOLDER, NO_DESCRIPTION);
        }
        line = line + NEW_LINE;
        return line;
    }

    private void format(ObjectEsParameter parameter, int indent) {
        this.output.append(this.formatLine((AbstractEsParameter)parameter, indent));
        parameter.getAllChildren().stream().forEach(l -> this.appendToOutput((AbstractEsParameter)l, indent + 1));
    }

    private void format(SingleEsParameter parameter, int indent) {
        this.output.append(this.formatLine((AbstractEsParameter)parameter, indent));
    }

    private void appendToOutput(AbstractEsParameter parameter, int indent) {
        if (parameter instanceof ObjectEsParameter) {
            this.format((ObjectEsParameter)parameter, indent);
        } else {
            this.format((SingleEsParameter)parameter, indent);
        }
    }

    private String formatH1(String line) {
        return "\n###" + line + NEW_LINE;
    }

    private String formatH2(String line) {
        return "\n####" + line + NEW_LINE;
    }

    public String create() {
        this.output = new StringBuilder();
        this.parameters.forEach((op, paramsByOrigin) -> {
            this.output.append(this.formatH1(op.toString()));
            paramsByOrigin.forEach((origin, params) -> {
                this.output.append(this.formatH2(origin.toString()));
                params.forEach(l -> this.appendToOutput((AbstractEsParameter)l, 0));
            });
        });
        return this.output.toString();
    }

    public Map<Description.Operation, Map<Description.InformationOrigin, List<AbstractEsParameter>>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<Description.Operation, Map<Description.InformationOrigin, List<AbstractEsParameter>>> parameters) {
        this.parameters = parameters;
    }
}

