/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.statistics.generator;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.n52.iceland.statistics.api.mappings.MetadataDataMapping;
import org.n52.iceland.statistics.api.mappings.ServiceEventDataMapping;
import org.n52.iceland.statistics.api.parameters.AbstractEsParameter;
import org.n52.iceland.statistics.api.parameters.Description;
import org.n52.iceland.statistics.generator.formats.MdFormat;

public class ParameterGenerator {
    public void processClass(String filePath, List<Class<?>> classes) throws IOException {
        MdFormat formatter = new MdFormat();
        formatter.setParameters(this.getParameters(classes));
        String printable = formatter.create();
        try {
            Files.write(Paths.get(filePath, new String[0]), printable.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private Map<Description.Operation, Map<Description.InformationOrigin, List<AbstractEsParameter>>> getParameters(List<Class<?>> classes) {
        return classes.stream().map(Class::getFields).flatMap(Arrays::stream).map(this::getFieldValue).filter(Objects::nonNull).filter(AbstractEsParameter::hasDescription).collect(Collectors.groupingBy(l -> l.getDescription().getOperation(), Collectors.groupingBy(l -> l.getDescription().getInformationOrigin())));
    }

    private AbstractEsParameter getFieldValue(Field field) {
        if (Modifier.isFinal(field.getModifiers()) && Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers()) && field.getType().isAssignableFrom(AbstractEsParameter.class)) {
            try {
                return (AbstractEsParameter)field.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        if (args.length >= 2) {
            String outputFilePath = args[0];
            ParameterGenerator gen = new ParameterGenerator();
            ArrayList processClasses = new ArrayList(args.length + 1);
            for (int i = 1; i < args.length; ++i) {
                processClasses.add(Class.forName(args[i]));
            }
            processClasses.add(MetadataDataMapping.class);
            processClasses.add(ServiceEventDataMapping.class);
            gen.processClass(outputFilePath, processClasses);
        } else {
            System.out.println("Application's DataMapping class is not specified. Add the class name of your data mapping class.");
            System.out.printf("Usage java -jar statistics-kibana %s [%s]%n", "..\\PARAMETERS.MD", "SosDataMapping");
        }
    }
}

