/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.odata.core.expr;

import java.util.Objects;
import org.n52.svalbard.odata.core.expr.DirectTextExpr;
import org.n52.svalbard.odata.core.expr.ExprVisitor;

public class StringValueExpr
implements DirectTextExpr {
    private final String value;

    public StringValueExpr(String value) {
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("'%s'", this.value);
    }

    @Override
    public <T, X extends Throwable> T accept(ExprVisitor<T, X> visitor) throws X {
        return visitor.visitString(this);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringValueExpr)) {
            return false;
        }
        return Objects.equals(this.value, ((StringValueExpr)o).getValue());
    }
}

