/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.odata.core.expr;

import java.util.Objects;
import java.util.Optional;
import org.n52.svalbard.odata.core.expr.Expr;

public abstract class BinaryExpr<T>
implements Expr {
    private static final String TO_STRING_TEMPLATE = "(%s %s %s)";
    private final T operator;
    private final Expr left;
    private final Expr right;

    public BinaryExpr(T operator, Expr left, Expr right) {
        this.operator = Objects.requireNonNull(operator);
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    public T getOperator() {
        return this.operator;
    }

    public Expr getLeft() {
        return this.left;
    }

    public Expr getRight() {
        return this.right;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public Optional<BinaryExpr<?>> asBinary() {
        return Optional.of(this);
    }

    public String toString() {
        return String.format(TO_STRING_TEMPLATE, this.left, this.operator.toString(), this.right);
    }

    public String toODataString() {
        return String.format(TO_STRING_TEMPLATE, this.left.toODataString(), this.operator.toString().toLowerCase(), this.right.toODataString());
    }

    public int hashCode() {
        return Objects.hash(this.operator, this.left, this.right);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinaryExpr)) {
            return false;
        }
        return Objects.equals(this.operator, ((BinaryExpr)o).getOperator()) && Objects.equals(this.left, ((BinaryExpr)o).getLeft()) && Objects.equals(this.right, ((BinaryExpr)o).getRight());
    }
}

