/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.odata.expr;

import java.util.Objects;
import java.util.Optional;
import org.n52.svalbard.odata.expr.Expr;

public abstract class BinaryExpr<T>
implements Expr {
    private final T operator;
    private final Expr left;
    private final Expr right;

    public BinaryExpr(T operator, Expr left, Expr right) {
        this.operator = Objects.requireNonNull(operator);
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    public T getOperator() {
        return this.operator;
    }

    public Expr getLeft() {
        return this.left;
    }

    public Expr getRight() {
        return this.right;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public Optional<BinaryExpr<?>> asBinary() {
        return Optional.of(this);
    }

    public String toString() {
        return String.format("(%s %s %s)", this.left, this.operator, this.right);
    }
}

