/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.odata.expr;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.n52.svalbard.odata.expr.BooleanExpr;
import org.n52.svalbard.odata.expr.Expr;
import org.n52.svalbard.odata.expr.ExprVisitor;

public class MethodCallExpr
implements Expr,
BooleanExpr {
    private final String name;
    private final List<Expr> parameters;

    public MethodCallExpr(String name, List<Expr> parameters) {
        this.name = Objects.requireNonNull(name);
        this.parameters = Objects.requireNonNull(parameters);
    }

    public String getName() {
        return this.name;
    }

    public List<Expr> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public boolean isMethodCall() {
        return true;
    }

    @Override
    public Optional<MethodCallExpr> asMethodCall() {
        return Optional.of(this);
    }

    public String toString() {
        return String.format("%s(%s)", this.name, this.parameters.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }

    @Override
    public <T, X extends Throwable> T accept(ExprVisitor<T, X> visitor) throws X {
        return visitor.visitMethodCall(this);
    }
}

