/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.odata.expr;

import java.util.Objects;
import java.util.Optional;
import org.n52.svalbard.odata.expr.Expr;

public abstract class UnaryExpr<T>
implements Expr {
    private final T operator;
    private final Expr operand;

    public UnaryExpr(T operator, Expr operand) {
        this.operator = Objects.requireNonNull(operator);
        this.operand = Objects.requireNonNull(operand);
    }

    public T getOperator() {
        return this.operator;
    }

    public Expr getOperand() {
        return this.operand;
    }

    @Override
    public Optional<UnaryExpr<?>> asUnary() {
        return Optional.of(this);
    }

    public String toString() {
        return String.format("(%s %s)", this.operator, this.operand);
    }
}

