/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.odata;

import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.core.edm.EdmProviderImpl;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.api.uri.queryoption.expression.MethodKind;
import org.apache.olingo.server.api.uri.queryoption.expression.UnaryOperatorKind;
import org.apache.olingo.server.core.ODataImpl;
import org.apache.olingo.server.core.uri.parser.Parser;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.n52.shetland.ogc.filter.BinaryLogicFilter;
import org.n52.shetland.ogc.filter.ComparisonFilter;
import org.n52.shetland.ogc.filter.Filter;
import org.n52.shetland.ogc.filter.FilterConstants;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.shetland.ogc.filter.UnaryLogicFilter;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.odata.ObservationCsdlEdmProvider;
import org.n52.svalbard.odata.core.expr.BinaryExpr;
import org.n52.svalbard.odata.core.expr.Expr;
import org.n52.svalbard.odata.core.expr.ExprVisitor;
import org.n52.svalbard.odata.core.expr.GeoValueExpr;
import org.n52.svalbard.odata.core.expr.MemberExpr;
import org.n52.svalbard.odata.core.expr.MethodCallExpr;
import org.n52.svalbard.odata.core.expr.StringValueExpr;
import org.n52.svalbard.odata.core.expr.TextExpr;
import org.n52.svalbard.odata.core.expr.UnaryExpr;
import org.n52.svalbard.odata.core.expr.arithmetic.NumericValueExpr;
import org.n52.svalbard.odata.core.expr.arithmetic.SimpleArithmeticExpr;
import org.n52.svalbard.odata.core.expr.bool.BooleanBinaryExpr;
import org.n52.svalbard.odata.core.expr.bool.BooleanExpr;
import org.n52.svalbard.odata.core.expr.bool.BooleanUnaryExpr;
import org.n52.svalbard.odata.core.expr.bool.ComparisonExpr;
import org.n52.svalbard.odata.core.expr.temporal.TimeValueExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataFesParser
implements Decoder<Filter<?>, String> {
    private static final String METHOD_CONTAINS = "contains";
    private static final String METHOD_STARTS_WITH = "startswith";
    private static final String METHOD_ENDS_WITH = "endswith";
    private static final String METHOD_GEO_INTERSECTS = "geo.intersects";
    private static final Logger LOG = LoggerFactory.getLogger(ODataFesParser.class);
    private static final String PATH = "/ObservationCollection";
    private static final String FRAGMENT = "";
    private static final String BASE_URI = "/";
    private static final String GEOGRAPHY_TYPE = "geography";
    private static final String SRID_PREFIX = "SRID=";
    private static final String GEOMETRY_TYPE = "geometry";
    private static final String FEATURE_EQUALS = "featureOfInterest eq '";
    private final Escaper urlEscaper = new PercentEscaper("-_.*", false);
    private final Edm edm;
    private final Parser parser;
    private final ObservationCsdlEdmProvider csdlProvider;
    private final ODataImpl odata = new ODataImpl();

    public ODataFesParser() {
        this.csdlProvider = new ObservationCsdlEdmProvider();
        this.edm = new EdmProviderImpl((CsdlEdmProvider)this.csdlProvider);
        this.parser = new Parser(this.edm, (OData)this.odata);
    }

    public Filter<?> decode(String objectToDecode) throws DecodingException {
        LOG.debug("Parsing filter: {}", (Object)objectToDecode);
        if (objectToDecode == null || objectToDecode.isEmpty()) {
            return null;
        }
        try {
            String encode = this.urlEscaper.escape(this.checkForGeoFitler(objectToDecode));
            UriInfo parseUri = this.parser.parseUri(PATH, "$filter=" + encode, FRAGMENT, BASE_URI);
            return (Filter)((Expr)parseUri.getFilterOption().getExpression().accept((ExpressionVisitor)new ExpressionGenerator())).accept(new RenamingVisitor(this.csdlProvider::mapProperty)).accept(new FilterGenerator());
        }
        catch (ODataException ex) {
            throw new DecodingException((Throwable)ex);
        }
    }

    public Set<DecoderKey> getKeys() {
        return Collections.emptySet();
    }

    private String checkForGeoFitler(String objectToDecode) {
        String modified = objectToDecode;
        if (objectToDecode.contains("geo.")) {
            modified = objectToDecode.replace(",'SRID", ",geometry'SRID").replace("(featureOfInterest,", "(featureOfInterest/shape,");
        } else if (objectToDecode.contains(FEATURE_EQUALS)) {
            modified = modified.replace(FEATURE_EQUALS, "featureOfInterest/id eq '");
        }
        return modified;
    }

    private static Geometry parseGeometry(StringValueExpr val) throws DecodingException {
        String value = val.getValue();
        if (value.startsWith(GEOGRAPHY_TYPE)) {
            value = value.substring(GEOGRAPHY_TYPE.length());
        }
        if (value.startsWith(GEOMETRY_TYPE)) {
            value = value.substring(GEOMETRY_TYPE.length());
        }
        value = ODataFesParser.stripQuotes(value).toUpperCase();
        int srid = 4326;
        if (value.startsWith(SRID_PREFIX)) {
            int sep = value.indexOf(59);
            if (sep > SRID_PREFIX.length() && value.length() > sep) {
                try {
                    srid = Integer.parseInt(value.substring(SRID_PREFIX.length(), sep));
                }
                catch (NumberFormatException ex) {
                    throw ODataFesParser.invalidGeometry(val, ex);
                }
                value = value.substring(sep + 1);
            } else {
                throw ODataFesParser.invalidGeometry(val);
            }
        }
        PrecisionModel precisionModel = new PrecisionModel(PrecisionModel.FLOATING);
        GeometryFactory geometryFactory = new GeometryFactory(precisionModel, srid);
        WKTReader wktReader = new WKTReader(geometryFactory);
        try {
            return wktReader.read(value);
        }
        catch (ParseException ex) {
            throw ODataFesParser.invalidGeometry(val, ex);
        }
    }

    private static Optional<MemberValueExprPair> getMemberValuePair(Expr first, Expr second) {
        if (first.asMember().isPresent()) {
            MemberExpr member = first.asMember().get();
            Optional<TextExpr> valueOpt = second.asTextValue();
            return valueOpt.map(textExpr -> new MemberValueExprPair(member, (TextExpr)textExpr));
        }
        MemberExpr member = second.asMember().get();
        Optional<TextExpr> valueOpt = first.asTextValue();
        return valueOpt.map(textExpr -> new MemberValueExprPair(member, (TextExpr)textExpr));
    }

    private static Optional<MemberValueExprPair> getMemberValuePair(BinaryExpr<?> expr) {
        return ODataFesParser.getMemberValuePair(expr.getLeft(), expr.getRight());
    }

    private static Optional<MemberValueExprPair> getMemberValuePair(List<Expr> expr) {
        if (expr.size() != 2) {
            return Optional.empty();
        }
        Iterator<Expr> iter = expr.iterator();
        return ODataFesParser.getMemberValuePair(iter.next(), iter.next());
    }

    @CheckReturnValue
    private static String stripQuotes(String value) {
        return value != null && value.length() >= 2 && value.startsWith("'") && value.endsWith("'") ? value.substring(1, value.length() - 1) : value;
    }

    private static Optional<FilterConstants.ComparisonOperator> getComparisonOperator(BinaryOperatorKind op) {
        switch (op) {
            case EQ: {
                return Optional.of(FilterConstants.ComparisonOperator.PropertyIsEqualTo);
            }
            case GE: {
                return Optional.of(FilterConstants.ComparisonOperator.PropertyIsGreaterThanOrEqualTo);
            }
            case LE: {
                return Optional.of(FilterConstants.ComparisonOperator.PropertyIsLessThanOrEqualTo);
            }
            case GT: {
                return Optional.of(FilterConstants.ComparisonOperator.PropertyIsGreaterThan);
            }
            case LT: {
                return Optional.of(FilterConstants.ComparisonOperator.PropertyIsLessThan);
            }
            case NE: {
                return Optional.of(FilterConstants.ComparisonOperator.PropertyIsNotEqualTo);
            }
        }
        return Optional.empty();
    }

    private static Optional<FilterConstants.BinaryLogicOperator> getLogicOperator(BinaryOperatorKind op) {
        switch (op) {
            case AND: {
                return Optional.of(FilterConstants.BinaryLogicOperator.And);
            }
            case OR: {
                return Optional.of(FilterConstants.BinaryLogicOperator.Or);
            }
        }
        return Optional.empty();
    }

    private static DecodingException invalidGeometry(StringValueExpr val) {
        return ODataFesParser.invalidGeometry(val, null);
    }

    private static DecodingException invalidGeometry(StringValueExpr val, Throwable cause) {
        return new DecodingException(cause, "invalid geometry: %s", val.getValue(), new Object[0]);
    }

    private static class RenamingVisitor
    extends AbstractExprTransformer<Error> {
        private final Function<String, String> mapper;

        RenamingVisitor(Function<String, String> mapper) {
            this.mapper = mapper;
        }

        @Override
        public Expr visitMember(MemberExpr expr) {
            return new MemberExpr(this.mapper.apply(expr.getValue()));
        }
    }

    private static class AbstractExprTransformer<T extends Throwable>
    implements ExprVisitor<Expr, T> {
        private AbstractExprTransformer() {
        }

        @Override
        public Expr visitBooleanBinary(BooleanBinaryExpr expr) throws T {
            FilterConstants.BinaryLogicOperator op = (FilterConstants.BinaryLogicOperator)expr.getOperator();
            BooleanExpr left = ((Expr)expr.getLeft().accept(this)).asBoolean().orElseThrow(Error::new);
            BooleanExpr right = ((Expr)expr.getRight().accept(this)).asBoolean().orElseThrow(Error::new);
            return new BooleanBinaryExpr(op, left, right);
        }

        @Override
        public Expr visitBooleanUnary(BooleanUnaryExpr expr) throws T {
            FilterConstants.UnaryLogicOperator op = (FilterConstants.UnaryLogicOperator)expr.getOperator();
            BooleanExpr operand = ((Expr)expr.getOperand().accept(this)).asBoolean().orElseThrow(Error::new);
            return new BooleanUnaryExpr(op, operand);
        }

        @Override
        public Expr visitComparison(ComparisonExpr expr) throws T {
            FilterConstants.ComparisonOperator op = (FilterConstants.ComparisonOperator)expr.getOperator();
            Expr left = (Expr)expr.getLeft().accept(this);
            Expr right = (Expr)expr.getRight().accept(this);
            return new ComparisonExpr(op, left, right);
        }

        @Override
        public Expr visitMethodCall(MethodCallExpr expr) throws T {
            String name = expr.getName();
            ArrayList<Expr> list = new ArrayList<Expr>(expr.getParameters().size());
            for (Expr e : expr.getParameters()) {
                list.add((Expr)e.accept(this));
            }
            return new MethodCallExpr(name, list);
        }

        @Override
        public Expr visitMember(MemberExpr expr) {
            String value = expr.getValue();
            return new MemberExpr(value);
        }

        @Override
        public Expr visitString(StringValueExpr expr) throws T {
            String value = expr.getValue();
            return new StringValueExpr(value);
        }

        @Override
        public Expr visitSimpleArithmetic(SimpleArithmeticExpr expr) throws T {
            return null;
        }

        @Override
        public Expr visitTime(TimeValueExpr expr) throws T {
            return null;
        }

        @Override
        public Expr visitGeometry(GeoValueExpr expr) throws T {
            return null;
        }

        @Override
        public Expr visitNumeric(NumericValueExpr expr) throws T {
            return null;
        }
    }

    private static final class FilterGenerator
    implements ExprVisitor<Filter<?>, DecodingException> {
        private static final String WILDCARD = "%";

        private FilterGenerator() {
        }

        @Override
        public Filter<?> visitBooleanBinary(BooleanBinaryExpr expr) throws DecodingException {
            return new BinaryLogicFilter((FilterConstants.BinaryLogicOperator)expr.getOperator(), (Filter)expr.getLeft().accept(this), (Filter)expr.getRight().accept(this));
        }

        @Override
        public Filter<?> visitBooleanUnary(BooleanUnaryExpr expr) throws DecodingException {
            return new UnaryLogicFilter((Filter)expr.getOperand().accept(this));
        }

        @Override
        public Filter<?> visitComparison(ComparisonExpr expr) throws DecodingException {
            MemberValueExprPair memberValuePair = (MemberValueExprPair)ODataFesParser.getMemberValuePair(expr).orElseThrow(this::unsupported);
            return new ComparisonFilter((FilterConstants.ComparisonOperator)expr.getOperator(), memberValuePair.getMember().getValue(), memberValuePair.getValue().getValue());
        }

        @Override
        public Filter<?> visitMethodCall(MethodCallExpr expr) throws DecodingException {
            switch (expr.getName()) {
                case "contains": {
                    MemberValueExprPair mv = (MemberValueExprPair)ODataFesParser.getMemberValuePair(expr.getParameters()).orElseThrow(this::unsupported);
                    String referenceValue = mv.getMember().getValue();
                    String value = WILDCARD + mv.getValue().getValue() + WILDCARD;
                    return new ComparisonFilter(FilterConstants.ComparisonOperator.PropertyIsLike, referenceValue, value);
                }
                case "startswith": {
                    MemberValueExprPair mv = (MemberValueExprPair)ODataFesParser.getMemberValuePair(expr.getParameters()).orElseThrow(this::unsupported);
                    String referenceValue = mv.getMember().getValue();
                    String value = mv.getValue().getValue() + WILDCARD;
                    return new ComparisonFilter(FilterConstants.ComparisonOperator.PropertyIsLike, referenceValue, value);
                }
                case "endswith": {
                    MemberValueExprPair mv = (MemberValueExprPair)ODataFesParser.getMemberValuePair(expr.getParameters()).orElseThrow(this::unsupported);
                    String referenceValue = mv.getMember().getValue();
                    String value = WILDCARD + mv.getValue().getValue();
                    return new ComparisonFilter(FilterConstants.ComparisonOperator.PropertyIsLike, referenceValue, value);
                }
                case "geo.intersects": {
                    MemberValueExprPair mv = (MemberValueExprPair)ODataFesParser.getMemberValuePair(expr.getParameters()).orElseThrow(this::unsupported);
                    String referenceValue = mv.getMember().getValue();
                    if (referenceValue.equals("om:featureOfInterest")) {
                        referenceValue = referenceValue + "/*/sams:shape";
                    }
                    Geometry geometry = ODataFesParser.parseGeometry(mv.getValue());
                    return new SpatialFilter(FilterConstants.SpatialOperator.Intersects, geometry, referenceValue);
                }
            }
            throw new DecodingException("unsupported method '%s'", expr.getName(), new Object[0]);
        }

        @Override
        public Filter<?> visitMember(MemberExpr expr) throws DecodingException {
            throw new DecodingException("unexpected member expression '%s'", expr.getValue(), new Object[0]);
        }

        @Override
        public Filter<?> visitString(StringValueExpr expr) throws DecodingException {
            return null;
        }

        @Override
        public Filter<?> visitSimpleArithmetic(SimpleArithmeticExpr expr) throws DecodingException {
            return null;
        }

        @Override
        public Filter<?> visitTime(TimeValueExpr expr) throws DecodingException {
            return null;
        }

        @Override
        public Filter<?> visitGeometry(GeoValueExpr expr) throws DecodingException {
            return null;
        }

        @Override
        public Filter<?> visitNumeric(NumericValueExpr expr) throws DecodingException {
            return null;
        }

        public Filter<?> visitValue(StringValueExpr expr) throws DecodingException {
            throw new DecodingException("unexpected value expression '%s'", expr.getValue(), new Object[0]);
        }

        private DecodingException unsupported() {
            return new DecodingException("unsupported expression", new Object[0]);
        }
    }

    private static final class ExpressionGenerator
    implements ExpressionVisitorAdapter<Expr> {
        private ExpressionGenerator() {
        }

        public Expr visitBinaryOperator(BinaryOperatorKind op, Expr left, Expr right) throws ExpressionVisitException {
            Supplier<ExpressionVisitException> exceptionSupplier = () -> new ExpressionVisitException(String.format("Operator %s is not supported: %s %s %s", op, left, op, right));
            switch (op) {
                case AND: 
                case OR: {
                    FilterConstants.BinaryLogicOperator operator = (FilterConstants.BinaryLogicOperator)ODataFesParser.getLogicOperator(op).orElseThrow(exceptionSupplier);
                    BooleanExpr leftOperand = left.asBoolean().orElseThrow(exceptionSupplier);
                    BooleanExpr rightOperand = right.asBoolean().orElseThrow(exceptionSupplier);
                    return new BooleanBinaryExpr(operator, leftOperand, rightOperand);
                }
                case EQ: 
                case GE: 
                case LE: 
                case GT: 
                case LT: 
                case NE: {
                    MemberValueExprPair mv = (MemberValueExprPair)ODataFesParser.getMemberValuePair(left, right).orElseThrow(exceptionSupplier);
                    FilterConstants.ComparisonOperator operator = (FilterConstants.ComparisonOperator)ODataFesParser.getComparisonOperator(op).orElseThrow(exceptionSupplier);
                    return new ComparisonExpr(operator, (Expr)mv.getMember(), (Expr)mv.getValue());
                }
            }
            throw exceptionSupplier.get();
        }

        public StringValueExpr visitLiteral(Literal literal) {
            return new StringValueExpr(ODataFesParser.stripQuotes(literal.getText()));
        }

        public MethodCallExpr visitMethodCall(MethodKind methodCall, List<Expr> parameters) {
            return new MethodCallExpr(methodCall.toString(), parameters);
        }

        public UnaryExpr<?> visitUnaryOperator(UnaryOperatorKind op, Expr operand) throws ExpressionVisitException {
            Supplier<ExpressionVisitException> exceptionSupplier = () -> new ExpressionVisitException(String.format("Operator is not supported: %s %s", op, operand));
            switch (op) {
                case NOT: {
                    return new BooleanUnaryExpr(FilterConstants.UnaryLogicOperator.Not, operand.asBoolean().orElseThrow(exceptionSupplier));
                }
            }
            throw exceptionSupplier.get();
        }

        public Expr visitLambdaExpression(String fun, String var, Expression expr) throws ExpressionVisitException {
            throw new ExpressionVisitException("Lambda expressions are not supported");
        }

        @Override
        public Expr visitMember(UriInfoResource member) throws ExpressionVisitException {
            return new MemberExpr(member.getUriResourceParts().stream().map(UriResource::getSegmentValue).collect(Collectors.joining(ODataFesParser.BASE_URI)));
        }

        public Expr visitAlias(String aliasName) throws ExpressionVisitException {
            throw new ExpressionVisitException("aliases are not supported");
        }

        public Expr visitTypeLiteral(EdmType type) throws ExpressionVisitException {
            throw new ExpressionVisitException("type literals are not supported");
        }

        public Expr visitLambdaReference(String variableName) throws ExpressionVisitException {
            throw new ExpressionVisitException("Lambda references are not supported");
        }

        public Expr visitEnum(EdmEnumType type, List<String> enumValues) throws ExpressionVisitException {
            throw new ExpressionVisitException("enums are not supported");
        }
    }

    private static interface ExpressionVisitorAdapter<T>
    extends ExpressionVisitor<T> {
        default public T visitBinaryOperator(BinaryOperatorKind operator, T left, List<T> right) throws ExpressionVisitException, ODataApplicationException {
            Object result = left;
            for (T expr : right) {
                result = this.visitBinaryOperator(operator, result, expr);
            }
            return result;
        }

        default public T visitMember(Member member) throws ExpressionVisitException, ODataApplicationException {
            return this.visitMember(member.getResourcePath());
        }

        public T visitMember(UriInfoResource var1) throws ExpressionVisitException, ODataApplicationException;
    }

    private static final class MemberValueExprPair {
        private final MemberExpr member;
        private final StringValueExpr value;

        MemberValueExprPair(MemberExpr member, TextExpr value) {
            this.member = Objects.requireNonNull(member);
            this.value = Objects.requireNonNull((StringValueExpr)value);
        }

        MemberExpr getMember() {
            return this.member;
        }

        StringValueExpr getValue() {
            return this.value;
        }
    }
}

