/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.odata.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.joda.time.DateTime;
import org.n52.shetland.filter.CountFilter;
import org.n52.shetland.filter.ExpandFilter;
import org.n52.shetland.filter.ExpandItem;
import org.n52.shetland.filter.FilterFilter;
import org.n52.shetland.filter.OrderByFilter;
import org.n52.shetland.filter.OrderProperty;
import org.n52.shetland.filter.SelectFilter;
import org.n52.shetland.filter.SkipTopFilter;
import org.n52.shetland.oasis.odata.ODataExpr;
import org.n52.shetland.oasis.odata.query.option.QueryOptions;
import org.n52.shetland.ogc.filter.FilterClause;
import org.n52.shetland.ogc.filter.FilterConstants;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.sta.exception.STAInvalidQueryError;
import org.n52.svalbard.odata.core.expr.Expr;
import org.n52.svalbard.odata.core.expr.GeoValueExpr;
import org.n52.svalbard.odata.core.expr.MemberExpr;
import org.n52.svalbard.odata.core.expr.MethodCallExpr;
import org.n52.svalbard.odata.core.expr.StringValueExpr;
import org.n52.svalbard.odata.core.expr.TextExpr;
import org.n52.svalbard.odata.core.expr.arithmetic.ArithmeticExpr;
import org.n52.svalbard.odata.core.expr.arithmetic.NumericValueExpr;
import org.n52.svalbard.odata.core.expr.arithmetic.SimpleArithmeticExpr;
import org.n52.svalbard.odata.core.expr.bool.BooleanBinaryExpr;
import org.n52.svalbard.odata.core.expr.bool.BooleanExpr;
import org.n52.svalbard.odata.core.expr.bool.BooleanUnaryExpr;
import org.n52.svalbard.odata.core.expr.bool.ComparisonExpr;
import org.n52.svalbard.odata.core.expr.temporal.TemporalExpr;
import org.n52.svalbard.odata.core.expr.temporal.TimeValueExpr;
import org.n52.svalbard.odata.grammar.STAQueryOptionsGrammar;
import org.n52.svalbard.odata.grammar.STAQueryOptionsGrammarBaseVisitor;

public class STAQueryOptionVisitor
extends STAQueryOptionsGrammarBaseVisitor {
    @Override
    public QueryOptions visitQueryOptions(STAQueryOptionsGrammar.QueryOptionsContext ctx) {
        HashSet<FilterClause> qops = new HashSet<FilterClause>();
        for (STAQueryOptionsGrammar.SystemQueryOptionContext systemQueryOptionContext : ctx.systemQueryOption()) {
            qops.add(this.visitSystemQueryOption(systemQueryOptionContext));
        }
        return new QueryOptions("", qops);
    }

    @Override
    public FilterClause visitSystemQueryOption(STAQueryOptionsGrammar.SystemQueryOptionContext ctx) {
        if (ctx.count() != null) {
            return this.visitCount(ctx.count());
        }
        if (ctx.expand() != null) {
            return this.visitExpand(ctx.expand());
        }
        if (ctx.filter() != null) {
            return this.visitFilter(ctx.filter());
        }
        if (ctx.orderby() != null) {
            return this.visitOrderby(ctx.orderby());
        }
        if (ctx.select() != null) {
            return this.visitSelect(ctx.select());
        }
        if (ctx.skip() != null) {
            return this.visitSkip(ctx.skip());
        }
        if (ctx.top() != null) {
            return this.visitTop(ctx.top());
        }
        return null;
    }

    @Override
    public SkipTopFilter visitSkip(STAQueryOptionsGrammar.SkipContext ctx) {
        return new SkipTopFilter(FilterConstants.SkipTopOperator.Skip, Long.valueOf(Long.parseLong(ctx.decimalLiteral().getText())));
    }

    @Override
    public SkipTopFilter visitTop(STAQueryOptionsGrammar.TopContext ctx) {
        return new SkipTopFilter(FilterConstants.SkipTopOperator.Top, Long.valueOf(Long.parseLong(ctx.decimalLiteral().getText())));
    }

    @Override
    public CountFilter visitCount(STAQueryOptionsGrammar.CountContext ctx) {
        return new CountFilter(true);
    }

    @Override
    public SelectFilter visitSelect(STAQueryOptionsGrammar.SelectContext ctx) {
        HashSet<String> pathFilterItems = new HashSet<String>();
        for (STAQueryOptionsGrammar.SelectItemContext selectItemContext : ctx.selectItem()) {
            pathFilterItems.add(this.visitSelectItem(selectItemContext));
        }
        return new SelectFilter(pathFilterItems);
    }

    @Override
    public String visitSelectItem(STAQueryOptionsGrammar.SelectItemContext ctx) {
        return ctx.getText();
    }

    @Override
    public OrderByFilter visitOrderby(STAQueryOptionsGrammar.OrderbyContext ctx) {
        ArrayList<OrderProperty> orderProperties = new ArrayList<OrderProperty>();
        for (STAQueryOptionsGrammar.OrderbyItemContext orderbyItemContext : ctx.orderbyItem()) {
            orderProperties.add(this.visitOrderbyItem(orderbyItemContext));
        }
        return new OrderByFilter(orderProperties);
    }

    @Override
    public OrderProperty visitOrderbyItem(STAQueryOptionsGrammar.OrderbyItemContext ctx) {
        if (ctx.ASC_LLC() != null) {
            return new OrderProperty(ctx.memberExpr().getText(), FilterConstants.SortOrder.ASC);
        }
        if (ctx.DESC_LLC() != null) {
            return new OrderProperty(ctx.memberExpr().getText(), FilterConstants.SortOrder.DESC);
        }
        return new OrderProperty(ctx.memberExpr().getText());
    }

    @Override
    public ExpandFilter visitExpand(STAQueryOptionsGrammar.ExpandContext ctx) {
        HashSet<ExpandItem> expandItems = new HashSet<ExpandItem>();
        for (STAQueryOptionsGrammar.ExpandItemContext expandItemContext : ctx.expandItem()) {
            expandItems.add(this.visitExpandItem(expandItemContext));
        }
        return this.createExpandFilter(expandItems);
    }

    private ExpandFilter createExpandFilter(Set<ExpandItem> items) {
        HashMap<String, ExpandItem> map = new HashMap<String, ExpandItem>();
        for (ExpandItem item : items) {
            if (map.containsKey(item.getPath())) {
                QueryOptions queryOptions = this.mergeQueryOptions(((ExpandItem)map.get(item.getPath())).getQueryOptions(), item.getQueryOptions());
                map.put(item.getPath(), new ExpandItem(item.getPath(), queryOptions));
                continue;
            }
            map.put(item.getPath(), item);
        }
        return new ExpandFilter(new HashSet(map.values()));
    }

    private QueryOptions mergeQueryOptions(QueryOptions qo1, QueryOptions qo2) {
        HashSet<Object> clauses = new HashSet<Object>();
        if (qo1.hasExpandFilter()) {
            if (qo2.hasExpandFilter()) {
                HashSet<ExpandItem> combined = new HashSet<ExpandItem>();
                combined.addAll(qo1.getExpandFilter().getItems());
                combined.addAll(qo2.getExpandFilter().getItems());
                clauses.add(this.createExpandFilter(combined));
            } else {
                clauses.add(qo1.getExpandFilter());
            }
        } else if (qo2.hasExpandFilter()) {
            clauses.add(qo2.getExpandFilter());
        }
        clauses.add(this.mergeOption(() -> ((QueryOptions)qo1).hasCountFilter(), () -> ((QueryOptions)qo1).getCountFilter(), () -> ((QueryOptions)qo2).hasCountFilter(), () -> ((QueryOptions)qo2).getCountFilter()));
        clauses.add(this.mergeOption(() -> ((QueryOptions)qo1).hasFilterFilter(), () -> ((QueryOptions)qo1).getFilterFilter(), () -> ((QueryOptions)qo2).hasFilterFilter(), () -> ((QueryOptions)qo2).getFilterFilter()));
        clauses.add(this.mergeOption(() -> ((QueryOptions)qo1).hasOrderByFilter(), () -> ((QueryOptions)qo1).getOrderByFilter(), () -> ((QueryOptions)qo2).hasOrderByFilter(), () -> ((QueryOptions)qo2).getOrderByFilter()));
        clauses.add(this.mergeOption(() -> ((QueryOptions)qo1).hasSelectFilter(), () -> ((QueryOptions)qo1).getSelectFilter(), () -> ((QueryOptions)qo2).hasSelectFilter(), () -> ((QueryOptions)qo2).getSelectFilter()));
        clauses.add(this.mergeOption(() -> ((QueryOptions)qo1).hasSkipFilter(), () -> ((QueryOptions)qo1).getSkipFilter(), () -> ((QueryOptions)qo2).hasSkipFilter(), () -> ((QueryOptions)qo2).getSkipFilter()));
        clauses.add(this.mergeOption(() -> ((QueryOptions)qo1).hasTopFilter(), () -> ((QueryOptions)qo1).getTopFilter(), () -> ((QueryOptions)qo2).hasTopFilter(), () -> ((QueryOptions)qo2).getTopFilter()));
        return new QueryOptions(qo1.getBaseURI(), clauses);
    }

    private FilterClause mergeOption(Supplier<Boolean> q1hasClause, Supplier<FilterClause> q1Clause, Supplier<Boolean> q2hasClause, Supplier<FilterClause> q2Clause) {
        if (q1hasClause.get().booleanValue()) {
            if (Objects.equals(q2Clause.get(), q1Clause.get())) {
                return q1Clause.get();
            }
            String empty = "null";
            throw new STAInvalidQueryError("Invalid Query. Tried to expand the same Entity multiple times with different QueryOptions! Could not merge: " + (q1hasClause.get() != false ? q1Clause.get().toString() : "null") + " and " + (q2hasClause.get() != false ? q2Clause.get().toString() : "null"));
        }
        if (q2hasClause.get().booleanValue()) {
            return q2Clause.get();
        }
        return null;
    }

    @Override
    public ExpandItem visitExpandItem(STAQueryOptionsGrammar.ExpandItemContext ctx) {
        if (!ctx.systemQueryOption().isEmpty()) {
            HashSet<FilterClause> options = new HashSet<FilterClause>();
            for (STAQueryOptionsGrammar.SystemQueryOptionContext expandQueryOptions : ctx.systemQueryOption()) {
                options.add(this.visitSystemQueryOption(expandQueryOptions));
            }
            return this.handleSlashRewrite(ctx, new QueryOptions("", options));
        }
        QueryOptions base = new QueryOptions("", null);
        return this.handleSlashRewrite(ctx, base);
    }

    private ExpandItem handleSlashRewrite(STAQueryOptionsGrammar.ExpandItemContext ctx, QueryOptions baseref) {
        QueryOptions base = baseref;
        if (!ctx.memberExpr().SLASH().isEmpty()) {
            for (int i = ctx.memberExpr().ALPHAPLUS().size() - 1; i >= 1; --i) {
                ExpandItem expandItem = new ExpandItem(ctx.memberExpr().ALPHAPLUS(i).getText(), base);
                ExpandFilter expandFilter = new ExpandFilter(expandItem);
                base = new QueryOptions("", Collections.singleton(expandFilter));
            }
        }
        return new ExpandItem(ctx.memberExpr().ALPHAPLUS(0).getText(), base);
    }

    @Override
    public FilterFilter visitFilter(STAQueryOptionsGrammar.FilterContext ctx) {
        return new FilterFilter((ODataExpr)this.visitBoolExpr(ctx.boolExpr()));
    }

    @Override
    public BooleanExpr visitBoolExpr(STAQueryOptionsGrammar.BoolExprContext ctx) {
        Expr right;
        BooleanExpr left = null;
        if (ctx.boolMethodCallExpr() != null) {
            left = this.visitBoolMethodCallExpr(ctx.boolMethodCallExpr());
        } else if (ctx.boolParenExpr() != null) {
            left = this.visitBoolParenExpr(ctx.boolParenExpr());
        } else if (ctx.notExpr() != null) {
            left = new BooleanUnaryExpr(FilterConstants.UnaryLogicOperator.Not, this.visitNotExpr(ctx.notExpr()));
        } else if (ctx.anyExpr() != null) {
            Expr common = this.visitAnyExpr(ctx.anyExpr());
            if (ctx.eqExpr() != null) {
                right = this.visitEqExpr(ctx.eqExpr());
                left = new ComparisonExpr(FilterConstants.ComparisonOperator.PropertyIsEqualTo, common, right);
            } else if (ctx.neExpr() != null) {
                right = this.visitNeExpr(ctx.neExpr());
                left = new ComparisonExpr(FilterConstants.ComparisonOperator.PropertyIsNotEqualTo, common, right);
            } else if (ctx.ltExpr() != null) {
                right = this.visitLtExpr(ctx.ltExpr());
                left = new ComparisonExpr(FilterConstants.ComparisonOperator.PropertyIsLessThan, common, right);
            } else if (ctx.leExpr() != null) {
                right = this.visitLeExpr(ctx.leExpr());
                left = new ComparisonExpr(FilterConstants.ComparisonOperator.PropertyIsLessThanOrEqualTo, common, right);
            } else if (ctx.gtExpr() != null) {
                right = this.visitGtExpr(ctx.gtExpr());
                left = new ComparisonExpr(FilterConstants.ComparisonOperator.PropertyIsGreaterThan, common, right);
            } else if (ctx.geExpr() != null) {
                right = this.visitGeExpr(ctx.geExpr());
                left = new ComparisonExpr(FilterConstants.ComparisonOperator.PropertyIsGreaterThanOrEqualTo, common, right);
            }
        }
        if (ctx.andExpr() != null) {
            right = this.visitAndExpr(ctx.andExpr());
            return new BooleanBinaryExpr(FilterConstants.BinaryLogicOperator.And, left, (BooleanExpr)right);
        }
        if (ctx.orExpr() != null) {
            right = this.visitOrExpr(ctx.orExpr());
            return new BooleanBinaryExpr(FilterConstants.BinaryLogicOperator.Or, left, (BooleanExpr)right);
        }
        return left;
    }

    @Override
    public Expr visitAnyExpr(STAQueryOptionsGrammar.AnyExprContext ctx) {
        if (ctx.memberExpr() != null) {
            return this.visitMemberExpr(ctx.memberExpr());
        }
        if (ctx.arithmeticExpr() != null) {
            return this.visitArithmeticExpr(ctx.arithmeticExpr());
        }
        if (ctx.geoExpr() != null) {
            return this.visitGeoExpr(ctx.geoExpr());
        }
        if (ctx.timeExpr() != null) {
            return this.visitTimeExpr(ctx.timeExpr());
        }
        if (ctx.textExpr() != null) {
            return this.visitTextExpr(ctx.textExpr());
        }
        if (ctx.parenExpr() != null) {
            return this.visitParenExpr(ctx.parenExpr());
        }
        return null;
    }

    @Override
    public ArithmeticExpr visitArithmeticExpr(STAQueryOptionsGrammar.ArithmeticExprContext ctx) {
        ArithmeticExpr left = ctx.numericLiteral() != null ? new NumericValueExpr(ctx.numericLiteral().getText()) : (ctx.memberExpr() != null ? new MemberExpr(ctx.memberExpr().getText()) : (ctx.negateExpr() != null ? new SimpleArithmeticExpr(FilterConstants.SimpleArithmeticOperator.Sub, new NumericValueExpr(0), this.visitArithmeticExpr(ctx.negateExpr().arithmeticExpr())) : this.visitArithmeticMethodCallExpr(ctx.arithmeticMethodCallExpr())));
        if (ctx.addExpr() != null) {
            ArithmeticExpr right = this.visitAddExpr(ctx.addExpr());
            return new SimpleArithmeticExpr(FilterConstants.SimpleArithmeticOperator.Add, left, right);
        }
        if (ctx.subExpr() != null) {
            ArithmeticExpr right = this.visitSubExpr(ctx.subExpr());
            return new SimpleArithmeticExpr(FilterConstants.SimpleArithmeticOperator.Sub, left, right);
        }
        if (ctx.mulExpr() != null) {
            ArithmeticExpr right = this.visitMulExpr(ctx.mulExpr());
            return new SimpleArithmeticExpr(FilterConstants.SimpleArithmeticOperator.Mul, left, right);
        }
        if (ctx.divExpr() != null) {
            ArithmeticExpr right = this.visitDivExpr(ctx.divExpr());
            return new SimpleArithmeticExpr(FilterConstants.SimpleArithmeticOperator.Div, left, right);
        }
        if (ctx.modExpr() != null) {
            ArithmeticExpr right = this.visitModExpr(ctx.modExpr());
            return new SimpleArithmeticExpr(FilterConstants.SimpleArithmeticOperator.Mod, left, right);
        }
        return left;
    }

    @Override
    public ArithmeticExpr visitArithmeticMethodCallExpr(STAQueryOptionsGrammar.ArithmeticMethodCallExprContext ctx) {
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (ctx.getChild(i) == null) continue;
            return (ArithmeticExpr)ctx.getChild(i).accept((ParseTreeVisitor)this);
        }
        return null;
    }

    @Override
    public BooleanExpr visitNotExpr(STAQueryOptionsGrammar.NotExprContext ctx) {
        return this.visitBoolExpr(ctx.boolExpr());
    }

    @Override
    public BooleanExpr visitBoolParenExpr(STAQueryOptionsGrammar.BoolParenExprContext ctx) {
        return this.visitBoolExpr(ctx.boolExpr());
    }

    @Override
    public BooleanExpr visitAndExpr(STAQueryOptionsGrammar.AndExprContext ctx) {
        return this.visitBoolExpr(ctx.boolExpr());
    }

    @Override
    public BooleanExpr visitOrExpr(STAQueryOptionsGrammar.OrExprContext ctx) {
        return this.visitBoolExpr(ctx.boolExpr());
    }

    @Override
    public Expr visitEqExpr(STAQueryOptionsGrammar.EqExprContext ctx) {
        return this.visitAnyExpr(ctx.anyExpr());
    }

    @Override
    public Expr visitNeExpr(STAQueryOptionsGrammar.NeExprContext ctx) {
        return this.visitAnyExpr(ctx.anyExpr());
    }

    @Override
    public Expr visitLtExpr(STAQueryOptionsGrammar.LtExprContext ctx) {
        return this.visitAnyExpr(ctx.anyExpr());
    }

    @Override
    public Expr visitLeExpr(STAQueryOptionsGrammar.LeExprContext ctx) {
        return this.visitAnyExpr(ctx.anyExpr());
    }

    @Override
    public Expr visitGtExpr(STAQueryOptionsGrammar.GtExprContext ctx) {
        return this.visitAnyExpr(ctx.anyExpr());
    }

    @Override
    public Expr visitGeExpr(STAQueryOptionsGrammar.GeExprContext ctx) {
        return this.visitAnyExpr(ctx.anyExpr());
    }

    @Override
    public ArithmeticExpr visitAddExpr(STAQueryOptionsGrammar.AddExprContext ctx) {
        return this.visitArithmeticExpr(ctx.arithmeticExpr());
    }

    @Override
    public ArithmeticExpr visitSubExpr(STAQueryOptionsGrammar.SubExprContext ctx) {
        return this.visitArithmeticExpr(ctx.arithmeticExpr());
    }

    @Override
    public ArithmeticExpr visitMulExpr(STAQueryOptionsGrammar.MulExprContext ctx) {
        return this.visitArithmeticExpr(ctx.arithmeticExpr());
    }

    @Override
    public ArithmeticExpr visitDivExpr(STAQueryOptionsGrammar.DivExprContext ctx) {
        return this.visitArithmeticExpr(ctx.arithmeticExpr());
    }

    @Override
    public ArithmeticExpr visitModExpr(STAQueryOptionsGrammar.ModExprContext ctx) {
        return this.visitArithmeticExpr(ctx.arithmeticExpr());
    }

    @Override
    public ArithmeticExpr visitLengthMethodCallExpr(STAQueryOptionsGrammar.LengthMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Length_LLC().getText(), this.visitTextOrMember(ctx.textOrMember()));
    }

    @Override
    public ArithmeticExpr visitIndexOfMethodCallExpr(STAQueryOptionsGrammar.IndexOfMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.IndexOf_LLC().getText(), this.visitTextOrMember(ctx.textOrMember(0)), this.visitTextOrMember(ctx.textOrMember(1)));
    }

    @Override
    public ArithmeticExpr visitYearMethodCallExpr(STAQueryOptionsGrammar.YearMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Year_LLC().getText(), this.visitTemporalOrMemberOrISO8601Timestamp(ctx.temporalOrMemberOrISO8601Timestamp()));
    }

    @Override
    public ArithmeticExpr visitMonthMethodCallExpr(STAQueryOptionsGrammar.MonthMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Month_LLC().getText(), this.visitTemporalOrMemberOrISO8601Timestamp(ctx.temporalOrMemberOrISO8601Timestamp()));
    }

    @Override
    public ArithmeticExpr visitDayMethodCallExpr(STAQueryOptionsGrammar.DayMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Day_LLC().getText(), this.visitTemporalOrMemberOrISO8601Timestamp(ctx.temporalOrMemberOrISO8601Timestamp()));
    }

    @Override
    public ArithmeticExpr visitDaysMethodCallExpr(STAQueryOptionsGrammar.DaysMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Days_LLC().getText(), this.visitTemporalOrMemberOrISO8601Timestamp(ctx.temporalOrMemberOrISO8601Timestamp()));
    }

    @Override
    public ArithmeticExpr visitHourMethodCallExpr(STAQueryOptionsGrammar.HourMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Hour_LLC().getText(), this.visitTemporalOrMemberOrISO8601Timestamp(ctx.temporalOrMemberOrISO8601Timestamp()));
    }

    @Override
    public ArithmeticExpr visitMinuteMethodCallExpr(STAQueryOptionsGrammar.MinuteMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Minute_LLC().getText(), this.visitTemporalOrMemberOrISO8601Timestamp(ctx.temporalOrMemberOrISO8601Timestamp()));
    }

    @Override
    public ArithmeticExpr visitSecondMethodCallExpr(STAQueryOptionsGrammar.SecondMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Second_LLC().getText(), this.visitTemporalOrMemberOrISO8601Timestamp(ctx.temporalOrMemberOrISO8601Timestamp()));
    }

    @Override
    public ArithmeticExpr visitDateMethodCallExpr(STAQueryOptionsGrammar.DateMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Date_LLC().getText(), this.visitTemporalOrMemberOrISO8601Timestamp(ctx.temporalOrMemberOrISO8601Timestamp()));
    }

    @Override
    public ArithmeticExpr visitRoundMethodCallExpr(STAQueryOptionsGrammar.RoundMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Round_LLC().getText(), this.visitArithmeticExpr(ctx.arithmeticExpr()));
    }

    @Override
    public ArithmeticExpr visitFloorMethodCallExpr(STAQueryOptionsGrammar.FloorMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Floor_LLC().getText(), this.visitArithmeticExpr(ctx.arithmeticExpr()));
    }

    @Override
    public ArithmeticExpr visitCeilingMethodCallExpr(STAQueryOptionsGrammar.CeilingMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Ceiling_LLC().getText(), this.visitArithmeticExpr(ctx.arithmeticExpr()));
    }

    @Override
    public ArithmeticExpr visitDistanceMethodCallExpr(STAQueryOptionsGrammar.DistanceMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.GeoDotDistance_LLC().getText(), this.visitGeoOrMember(ctx.geoOrMember(0)), this.visitGeoOrMember(ctx.geoOrMember(1)));
    }

    @Override
    public ArithmeticExpr visitGeoLengthMethodCallExpr(STAQueryOptionsGrammar.GeoLengthMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.GeoLength_LLC().getText(), this.visitGeoOrMember(ctx.geoOrMember()));
    }

    @Override
    public ArithmeticExpr visitTotalOffsetMinutesExpr(STAQueryOptionsGrammar.TotalOffsetMinutesExprContext ctx) {
        return new MethodCallExpr(ctx.TotalOffsetMinutes_LLC().getText(), this.visitTemporalOrMemberOrISO8601Timestamp(ctx.temporalOrMemberOrISO8601Timestamp()));
    }

    @Override
    public TextExpr visitTextOrMember(STAQueryOptionsGrammar.TextOrMemberContext ctx) {
        if (ctx.textExpr() != null) {
            return this.visitTextExpr(ctx.textExpr());
        }
        return new MemberExpr(ctx.memberExpr().getText());
    }

    @Override
    public TemporalExpr visitTemporalOrMemberOrISO8601Timestamp(STAQueryOptionsGrammar.TemporalOrMemberOrISO8601TimestampContext ctx) {
        if (ctx.temporalMethodCallExpr() != null) {
            return this.visitTemporalMethodCallExpr(ctx.temporalMethodCallExpr());
        }
        if (ctx.memberExpr() != null) {
            return new TimeValueExpr(ctx.memberExpr().getText());
        }
        return new TimeValueExpr(new TimeInstant(DateTime.parse((String)ctx.iso8601Timestamp().getText())));
    }

    @Override
    public GeoValueExpr visitGeoOrMember(STAQueryOptionsGrammar.GeoOrMemberContext ctx) {
        if (ctx.geoExpr() != null) {
            return new GeoValueExpr(ctx.geoExpr().getText());
        }
        return new GeoValueExpr(ctx.memberExpr().getText());
    }

    @Override
    public TemporalExpr visitTimeExpr(STAQueryOptionsGrammar.TimeExprContext ctx) {
        return this.visitTemporalOrMemberOrISO8601Timestamp(ctx.temporalOrMemberOrISO8601Timestamp());
    }

    @Override
    public GeoValueExpr visitGeoExpr(STAQueryOptionsGrammar.GeoExprContext ctx) {
        return new GeoValueExpr(ctx.getText());
    }

    @Override
    public TextExpr visitTextExpr(STAQueryOptionsGrammar.TextExprContext ctx) {
        if (ctx.escapedString() != null) {
            return new StringValueExpr(ctx.escapedString().getText().replace("'", ""));
        }
        return this.visitTextMethodCallExpr(ctx.textMethodCallExpr());
    }

    @Override
    public BooleanExpr visitBoolMethodCallExpr(STAQueryOptionsGrammar.BoolMethodCallExprContext ctx) {
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (ctx.getChild(i) == null) continue;
            return (BooleanExpr)ctx.getChild(i).accept((ParseTreeVisitor)this);
        }
        return null;
    }

    @Override
    public BooleanExpr visitEndsWithMethodCallExpr(STAQueryOptionsGrammar.EndsWithMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.EndsWith_LLC().getText(), this.visitTextOrMember(ctx.textOrMember(0)), this.visitTextOrMember(ctx.textOrMember(1)));
    }

    @Override
    public BooleanExpr visitStartsWithMethodCallExpr(STAQueryOptionsGrammar.StartsWithMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.StartsWith_LLC().getText(), this.visitTextOrMember(ctx.textOrMember(0)), this.visitTextOrMember(ctx.textOrMember(1)));
    }

    @Override
    public BooleanExpr visitSubstringOfMethodCallExpr(STAQueryOptionsGrammar.SubstringOfMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.SubStringOf_LLC().getText(), this.visitTextOrMember(ctx.textOrMember(0)), this.visitTextOrMember(ctx.textOrMember(1)));
    }

    @Override
    public BooleanExpr visitIntersectsMethodCallExpr(STAQueryOptionsGrammar.IntersectsMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.GeoDotIntersects_LLC().getText(), this.visitGeoOrMember(ctx.geoOrMember(0)), this.visitGeoOrMember(ctx.geoOrMember(1)));
    }

    @Override
    public Object visitSt_equalsMethodCallExpr(STAQueryOptionsGrammar.St_equalsMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.ST_equals_LLC().getText(), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(0)), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(1)));
    }

    @Override
    public Object visitSt_disjointMethodCallExpr(STAQueryOptionsGrammar.St_disjointMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.ST_disjoint_LLC().getText(), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(0)), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(1)));
    }

    @Override
    public Object visitSt_touchesMethodCallExpr(STAQueryOptionsGrammar.St_touchesMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.ST_touches_LLC().getText(), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(0)), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(1)));
    }

    @Override
    public Object visitSt_withinMethodCallExpr(STAQueryOptionsGrammar.St_withinMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.ST_within_LLC().getText(), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(0)), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(1)));
    }

    @Override
    public Object visitSt_overlapsMethodCallExpr(STAQueryOptionsGrammar.St_overlapsMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.ST_overlaps_LLC().getText(), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(0)), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(1)));
    }

    @Override
    public Object visitSt_crossesMethodCallExpr(STAQueryOptionsGrammar.St_crossesMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.ST_crosses_LLC().getText(), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(0)), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(1)));
    }

    @Override
    public Object visitSt_intersectsMethodCallExpr(STAQueryOptionsGrammar.St_intersectsMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.ST_intersects_LLC().getText(), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(0)), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(1)));
    }

    @Override
    public Object visitSt_containsMethodCallExpr(STAQueryOptionsGrammar.St_containsMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.ST_contains_LLC().getText(), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(0)), this.visitGeoOrMember(ctx.st_commonMethodCallExpr().geoOrMember(1)));
    }

    @Override
    public Object visitSt_relateMethodCallExpr(STAQueryOptionsGrammar.St_relateMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.ST_relate_LLC().getText(), this.visitGeoOrMember(ctx.geoOrMember(0)), this.visitGeoOrMember(ctx.geoOrMember(1)), new StringValueExpr(ctx.escapedString().getText()));
    }

    @Override
    public TextExpr visitTextMethodCallExpr(STAQueryOptionsGrammar.TextMethodCallExprContext ctx) {
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (ctx.getChild(i) == null) continue;
            return (TextExpr)ctx.getChild(i).accept((ParseTreeVisitor)this);
        }
        return null;
    }

    @Override
    public TemporalExpr visitTemporalMethodCallExpr(STAQueryOptionsGrammar.TemporalMethodCallExprContext ctx) {
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (ctx.getChild(i) == null) continue;
            return (TemporalExpr)ctx.getChild(i).accept((ParseTreeVisitor)this);
        }
        return null;
    }

    @Override
    public MethodCallExpr visitNowDate(STAQueryOptionsGrammar.NowDateContext ctx) {
        return new MethodCallExpr(ctx.Now_LLC().getText(), new Expr[0]);
    }

    @Override
    public MethodCallExpr visitMinDate(STAQueryOptionsGrammar.MinDateContext ctx) {
        return new MethodCallExpr(ctx.MinDateTime_LLC().getText(), new Expr[0]);
    }

    @Override
    public Object visitMaxDate(STAQueryOptionsGrammar.MaxDateContext ctx) {
        return new MethodCallExpr(ctx.MaxDateTime_LLC().getText(), new Expr[0]);
    }

    @Override
    public MethodCallExpr visitTimeMethodCallExpr(STAQueryOptionsGrammar.TimeMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Time_LLC().getText(), this.visitTemporalOrMemberOrISO8601Timestamp(ctx.temporalOrMemberOrISO8601Timestamp()));
    }

    @Override
    public MemberExpr visitMemberExpr(STAQueryOptionsGrammar.MemberExprContext ctx) {
        return new MemberExpr(ctx.getText());
    }

    @Override
    public TextExpr visitToLowerMethodCallExpr(STAQueryOptionsGrammar.ToLowerMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.ToLower_LLC().getText(), this.visitTextOrMember(ctx.textOrMember()));
    }

    @Override
    public TextExpr visitToUpperMethodCallExpr(STAQueryOptionsGrammar.ToUpperMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.ToUpper_LLC().getText(), this.visitTextOrMember(ctx.textOrMember()));
    }

    @Override
    public TextExpr visitTrimMethodCallExpr(STAQueryOptionsGrammar.TrimMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Trim_LLC().getText(), this.visitTextOrMember(ctx.textOrMember()));
    }

    @Override
    public TextExpr visitSubstringMethodCallExpr(STAQueryOptionsGrammar.SubstringMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Substring_LLC().getText(), this.visitTextOrMember(ctx.textOrMember()), this.visitArithmeticExpr(ctx.arithmeticExpr()));
    }

    @Override
    public TextExpr visitConcatMethodCallExpr(STAQueryOptionsGrammar.ConcatMethodCallExprContext ctx) {
        return new MethodCallExpr(ctx.Concat_LLC().getText(), this.visitTextOrMember(ctx.textOrMember(0)), this.visitTextOrMember(ctx.textOrMember(1)));
    }

    @Override
    public Expr visitParenExpr(STAQueryOptionsGrammar.ParenExprContext ctx) {
        return this.visitAnyExpr(ctx.anyExpr());
    }
}

