/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.odata.core.expr.arithmetic;

import java.util.Objects;
import java.util.Optional;
import org.n52.svalbard.odata.core.expr.ExprVisitor;
import org.n52.svalbard.odata.core.expr.arithmetic.ArithmeticExpr;

public class NumericValueExpr
implements ArithmeticExpr {
    private final Number value;

    public NumericValueExpr(Number value) {
        this.value = Objects.requireNonNull(value);
    }

    public NumericValueExpr(String value) {
        this.value = Objects.requireNonNull(Double.valueOf(value));
    }

    public Number getValue() {
        return this.value;
    }

    @Override
    public boolean isNumericValue() {
        return true;
    }

    @Override
    public Optional<NumericValueExpr> asNumericValue() {
        return Optional.of(this);
    }

    public String toString() {
        return String.format("As float: '%f'", Float.valueOf(this.value.floatValue()));
    }

    public String toODataString() {
        return Float.toString(this.value.floatValue());
    }

    @Override
    public <T, X extends Throwable> T accept(ExprVisitor<T, X> visitor) throws X {
        return visitor.visitNumeric(this);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NumericValueExpr)) {
            return false;
        }
        return Objects.equals(this.value, ((NumericValueExpr)o).getValue());
    }
}

