/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.odata;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAbstractEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.ex.ODataException;

public class ObservationCsdlEdmProvider
extends CsdlAbstractEdmProvider {
    private static final String CONTAINER_NAME = "Container";
    private static final String NS_OM = "om";
    private static final String NS_GML = "gml";

    public CsdlEntityContainer getEntityContainer() throws ODataException {
        CsdlEntityContainer entityContainer = new CsdlEntityContainer();
        entityContainer.setName(CONTAINER_NAME);
        entityContainer.setEntitySets(Collections.singletonList(this.getEntitySet(FQN.CONTAINER, "ObservationCollection")));
        return entityContainer;
    }

    public CsdlEntityContainerInfo getEntityContainerInfo(FullQualifiedName name) throws ODataException {
        if (name == null || name.equals((Object)FQN.CONTAINER)) {
            return ObservationCsdlEdmProvider.newEntityContainerInfo(FQN.CONTAINER);
        }
        return super.getEntityContainerInfo(name);
    }

    public CsdlEntitySet getEntitySet(FullQualifiedName container, String name) throws ODataException {
        if (container.equals((Object)FQN.CONTAINER) && name.equals("ObservationCollection")) {
            return ObservationCsdlEdmProvider.newEntitySet("ObservationCollection", FQN.OBSERVATION);
        }
        return super.getEntitySet(container, name);
    }

    public String mapProperty(String property) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "value": 
            case "values": 
            case "countValue": 
            case "countValues": 
            case "numericValue": 
            case "numericValues": 
            case "textValue": 
            case "textValues": 
            case "quantity": 
            case "quantities": 
            case "result": {
                return "om:result";
            }
            case "samplingGeometry": {
                return "http://www.opengis.net/req/omxml/2.0/data/samplingGeometry";
            }
            case "phenomenonTime": {
                return "om:phenomenonTime";
            }
            case "resultTime": {
                return "om:resultTime";
            }
            case "validTime": {
                return "om:validTime";
            }
            case "observedProperty": {
                return "om:observedProperty";
            }
            case "procedure": {
                return "om:procedure";
            }
            case "featureOfInterest/id": 
            case "featureOfInterest": {
                return "om:featureOfInterest";
            }
            case "feature": 
            case "featureOfInterest/shape": {
                return "om:featureOfInterest/*/sams:shape";
            }
            case "offering": {
                return "sos:offering";
            }
            case "id": 
            case "identifier": {
                return "gml:identifier";
            }
        }
        return property;
    }

    public CsdlEntityType getEntityType(FullQualifiedName name) throws ODataException {
        if (name.equals((Object)FQN.OBSERVATION)) {
            return new CsdlEntityType().setName(FQN.OBSERVATION.getName()).setKey(Collections.singletonList(ObservationCsdlEdmProvider.newPropertyRef("identifier"))).setOpenType(true).setProperties(Arrays.asList(ObservationCsdlEdmProvider.newProperty("identifier", FQN.STRING), ObservationCsdlEdmProvider.newProperty("id", FQN.STRING), ObservationCsdlEdmProvider.newProperty("value", FQN.STRING), ObservationCsdlEdmProvider.newProperty("values", FQN.STRING), ObservationCsdlEdmProvider.newProperty("countValue", FQN.COUNT), ObservationCsdlEdmProvider.newProperty("countValues", FQN.COUNT), ObservationCsdlEdmProvider.newProperty("numericValue", FQN.QUANTITY), ObservationCsdlEdmProvider.newProperty("numericValues", FQN.QUANTITY), ObservationCsdlEdmProvider.newProperty("quantity", FQN.QUANTITY), ObservationCsdlEdmProvider.newProperty("quantities", FQN.QUANTITY), ObservationCsdlEdmProvider.newProperty("textValue", FQN.STRING), ObservationCsdlEdmProvider.newProperty("textValues", FQN.STRING), ObservationCsdlEdmProvider.newProperty("result", FQN.STRING), ObservationCsdlEdmProvider.newProperty("phenomenonTime", FQN.ABSTRACT_TIME_OBJECT), ObservationCsdlEdmProvider.newProperty("resultTime", FQN.ABSTRACT_TIME_OBJECT), ObservationCsdlEdmProvider.newProperty("validTime", FQN.TIME_PERIOD), ObservationCsdlEdmProvider.newProperty("observedProperty", FQN.STRING), ObservationCsdlEdmProvider.newProperty("procedure", FQN.STRING), ObservationCsdlEdmProvider.newProperty("feature", FQN.FEATURE_OF_INTEREST), ObservationCsdlEdmProvider.newProperty("featureOfInterest", FQN.FEATURE_OF_INTEREST), ObservationCsdlEdmProvider.newProperty("samplingGeometry", FQN.GEOMETRY_POINT), ObservationCsdlEdmProvider.newProperty("offering", FQN.STRING)));
        }
        return super.getEntityType(name);
    }

    public List<CsdlSchema> getSchemas() throws ODataException {
        return Collections.singletonList(new CsdlSchema().setNamespace(NS_OM).setComplexTypes(Arrays.asList(this.getComplexType(FQN.ABSTRACT_TIME_OBJECT), this.getComplexType(FQN.TIME_INSTANT), this.getComplexType(FQN.TIME_PERIOD), this.getComplexType(FQN.RESULT), this.getComplexType(FQN.FEATURE_OF_INTEREST))).setEntityTypes(Arrays.asList(this.getEntityType(FQN.OBSERVATION))).setEntityContainer(this.getEntityContainer()));
    }

    public CsdlComplexType getComplexType(FullQualifiedName name) throws ODataException {
        if (name.equals((Object)FQN.ABSTRACT_TIME_OBJECT)) {
            return ObservationCsdlEdmProvider.newAbstractComplexType(FQN.ABSTRACT_TIME_OBJECT, new CsdlProperty[0]);
        }
        if (name.equals((Object)FQN.TIME_INSTANT)) {
            return ObservationCsdlEdmProvider.newComplexType(FQN.TIME_INSTANT, FQN.ABSTRACT_TIME_OBJECT, new CsdlProperty[0]);
        }
        if (name.equals((Object)FQN.TIME_PERIOD)) {
            return ObservationCsdlEdmProvider.newComplexType(FQN.TIME_PERIOD, FQN.ABSTRACT_TIME_OBJECT, ObservationCsdlEdmProvider.newProperty("beginPosition", FQN.DATE_TIME), ObservationCsdlEdmProvider.newProperty("endPosition", FQN.DATE_TIME));
        }
        if (name.equals((Object)FQN.FEATURE_OF_INTEREST)) {
            return ObservationCsdlEdmProvider.newComplexType(FQN.FEATURE_OF_INTEREST, ObservationCsdlEdmProvider.newProperty("id", FQN.STRING), ObservationCsdlEdmProvider.newProperty("shape", FQN.GEOMETRY_POINT));
        }
        if (name.equals((Object)FQN.RESULT)) {
            return ObservationCsdlEdmProvider.newAbstractComplexType(FQN.RESULT, new CsdlProperty[0]);
        }
        return super.getComplexType(name);
    }

    private static CsdlProperty newProperty(String name, FullQualifiedName type) {
        return new CsdlProperty().setName(name).setType(type);
    }

    private static CsdlEntitySet newEntitySet(String name, FullQualifiedName type) {
        return new CsdlEntitySet().setName(name).setType(type);
    }

    private static CsdlEntityContainerInfo newEntityContainerInfo(FullQualifiedName name) {
        return new CsdlEntityContainerInfo().setContainerName(name);
    }

    private static CsdlPropertyRef newPropertyRef(String name) {
        return new CsdlPropertyRef().setName(name);
    }

    private static CsdlComplexType newAbstractComplexType(FullQualifiedName name, CsdlProperty ... properties) {
        return new CsdlComplexType().setOpenType(true).setAbstract(true).setName(name.getName()).setProperties(Arrays.asList(properties));
    }

    private static CsdlComplexType newComplexType(FullQualifiedName name, CsdlProperty ... properties) {
        return new CsdlComplexType().setOpenType(true).setAbstract(false).setName(name.getName()).setProperties(Arrays.asList(properties));
    }

    private static CsdlComplexType newComplexType(FullQualifiedName name, FullQualifiedName base, CsdlProperty ... properties) {
        return ObservationCsdlEdmProvider.newComplexType(name, properties).setBaseType(base);
    }

    private static interface ValueReference {
        public static final String RESULT = "om:result";
        public static final String PHENOMENON_TIME = "om:phenomenonTime";
        public static final String RESULT_TIME = "om:resultTime";
        public static final String VALID_TIME = "om:validTime";
        public static final String OBSERVED_PROPERTY = "om:observedProperty";
        public static final String PROCEDURE = "om:procedure";
        public static final String FEATURE_OF_INTEREST = "om:featureOfInterest";
        public static final String OFFERING = "sos:offering";
        public static final String IDENTIFIER = "gml:identifier";
        public static final String FEATURE_OF_INTEREST_SHAPE = "om:featureOfInterest/*/sams:shape";
        public static final String SAMPLING_GEOMETRY = "http://www.opengis.net/req/omxml/2.0/data/samplingGeometry";
    }

    private static interface Prop {
        public static final String VALUE = "value";
        public static final String VALUES = "values";
        public static final String COUNT_VALUE = "countValue";
        public static final String COUNT_VALUES = "countValues";
        public static final String NUMERIC_VALUE = "numericValue";
        public static final String NUMERIC_VALUES = "numericValues";
        public static final String TEXT_VALUE = "textValue";
        public static final String TEXT_VALUES = "textValues";
        public static final String OFFERING = "offering";
        public static final String SAMPLING_GEOMETRY = "samplingGeometry";
        public static final String QUANTITIES = "quantities";
        public static final String QUANTITY = "quantity";
        public static final String ID = "id";
        public static final String IDENTIFIER = "identifier";
        public static final String RESULT = "result";
        public static final String PHENOMENON_TIME = "phenomenonTime";
        public static final String RESULT_TIME = "resultTime";
        public static final String VALID_TIME = "validTime";
        public static final String PROCEDURE = "procedure";
        public static final String FEATURE_OF_INTEREST = "featureOfInterest";
        public static final String OBSERVED_PROPERTY = "observedProperty";
        public static final String OBSERVATION_COLLECTION = "ObservationCollection";
        public static final String OBSERVATION = "Observation";
        public static final String ABSTRACT_TIME_OBJECT = "_TimeObject";
        public static final String TIME_INSTANT = "TimeInstant";
        public static final String TIME_PERIOD = "TimePeriod";
        public static final String SHAPE = "shape";
        public static final String EN_END_POSITION = "endPosition";
        public static final String EN_BEGIN_POSITION = "beginPosition";
        public static final String FEATURE = "feature";
        public static final String FEATURE_OF_INTEREST_ID = "featureOfInterest/id";
        public static final String FEATURE_OF_INTEREST_SHAPE = "featureOfInterest/shape";
    }

    private static interface FQN {
        public static final FullQualifiedName CONTAINER = new FullQualifiedName("om", "Container");
        public static final FullQualifiedName OBSERVATION = new FullQualifiedName("om", "Observation");
        public static final FullQualifiedName TIME_PERIOD = new FullQualifiedName("om", "TimePeriod");
        public static final FullQualifiedName ABSTRACT_TIME_OBJECT = new FullQualifiedName("gml", "_TimeObject");
        public static final FullQualifiedName TIME_INSTANT = new FullQualifiedName("om", "TimeInstant");
        public static final FullQualifiedName RESULT = new FullQualifiedName("om", "result");
        public static final FullQualifiedName FEATURE_OF_INTEREST = new FullQualifiedName("om", "featureOfInterest");
        public static final FullQualifiedName STRING = EdmPrimitiveTypeKind.String.getFullQualifiedName();
        public static final FullQualifiedName DATE_TIME = EdmPrimitiveTypeKind.String.getFullQualifiedName();
        public static final FullQualifiedName QUANTITY = EdmPrimitiveTypeKind.Decimal.getFullQualifiedName();
        public static final FullQualifiedName COUNT = EdmPrimitiveTypeKind.Int64.getFullQualifiedName();
        public static final FullQualifiedName GEOMETRY_POINT = EdmPrimitiveTypeKind.GeometryPoint.getFullQualifiedName();
    }
}

